"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryRuleMetadataEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_query_rules/public/components/query_ruleset_detail/query_rule_flyout/query_rule_metadata_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const QueryRuleMetadataEditor = ({
  onRemove,
  criteria,
  onChange,
  error
}) => {
  var _criteria$values;
  const [metadataField, setMetadataField] = (0, _react.useState)(criteria.metadata || '');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "searchQueryRulesQueryRuleMetadataEditor",
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.search.queryRulesetDetail.queryRuleFlyout.metadataEditorLabel",
      defaultMessage: "Metadata field",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 21
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.search.queryRulesetDetail.queryRuleFlyout.metadataEditorTooltip', {
        defaultMessage: 'Metadata is used to match documents based on their query criteria. Metadata is ignored when the type is set to "always".'
      }),
      type: "question",
      color: "subdued",
      "aria-label": _i18n.i18n.translate('xpack.search.queryRulesetDetail.queryRuleFlyout.metadataEditorTooltipLabel', {
        defaultMessage: 'Metadata field tooltip'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 19
      }
    }))),
    isInvalid: !!(error !== null && error !== void 0 && error.metadata),
    error: error !== null && error !== void 0 && error.metadata ? error.metadata.message : undefined,
    isDisabled: criteria.type === 'always',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: !!(error !== null && error !== void 0 && error.metadata),
    "data-test-subj": "searchQueryRulesQueryRuleMetadataEditorField",
    fullWidth: true,
    "aria-label": _i18n.i18n.translate('xpack.search.queryRulesetDetail.queryRuleFlyout.metadataEditorLabel', {
      defaultMessage: 'Enter metadata field name'
    }),
    value: metadataField,
    onChange: e => {
      setMetadataField(e.target.value);
    },
    onBlur: () => {
      onChange({
        ...criteria,
        metadata: metadataField
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart",
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.search.queryRulesetDetail.queryRuleFlyout.metadataEditorOperatorLabel', {
      defaultMessage: 'Match type'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "searchQueryRulesQueryRuleMetadataEditorSelect",
    "aria-label": _i18n.i18n.translate('xpack.search.queryRulesetDetail.queryRuleFlyout.metadataEditorOperatorLabel', {
      defaultMessage: 'Select matching type'
    }),
    options: [{
      value: 'global',
      text: _i18n.i18n.translate('xpack.search.queryRulesetDetail.queryRuleFlyout.operatorGlobal', {
        defaultMessage: 'global'
      })
    }, {
      value: 'exact',
      text: _i18n.i18n.translate('xpack.search.queryRulesetDetail.queryRuleFlyout.operatorExact', {
        defaultMessage: 'exact'
      })
    }, {
      value: 'exact_fuzzy',
      text: _i18n.i18n.translate('xpack.search.queryRulesetDetail.queryRuleFlyout.operatorExactFuzzy', {
        defaultMessage: 'exact fuzzy'
      })
    }, {
      value: 'fuzzy',
      text: _i18n.i18n.translate('xpack.search.queryRulesetDetail.queryRuleFlyout.operatorFuzzy', {
        defaultMessage: 'fuzzy'
      })
    }, {
      value: 'prefix',
      text: _i18n.i18n.translate('xpack.search.queryRulesetDetail.queryRuleFlyout.operatorPrefix', {
        defaultMessage: 'prefix'
      })
    }, {
      value: 'suffix',
      text: _i18n.i18n.translate('xpack.search.queryRulesetDetail.queryRuleFlyout.operatorSuffix', {
        defaultMessage: 'suffix'
      })
    }, {
      value: 'contains',
      text: _i18n.i18n.translate('xpack.search.queryRulesetDetail.queryRuleFlyout.operatorContains', {
        defaultMessage: 'contains'
      })
    }, {
      value: 'lt',
      text: _i18n.i18n.translate('xpack.search.queryRulesetDetail.queryRuleFlyout.operatorLessThan', {
        defaultMessage: 'less than'
      })
    }, {
      value: 'lte',
      text: _i18n.i18n.translate('xpack.search.queryRulesetDetail.queryRuleFlyout.operatorLessThanOrEqual', {
        defaultMessage: 'less than or equal'
      })
    }, {
      value: 'gt',
      text: _i18n.i18n.translate('xpack.search.queryRulesetDetail.queryRuleFlyout.operatorGreaterThan', {
        defaultMessage: 'greater than'
      })
    }, {
      value: 'gte',
      text: _i18n.i18n.translate('xpack.search.queryRulesetDetail.queryRuleFlyout.operatorGreaterThanOrEqual', {
        defaultMessage: 'greater than or equal'
      })
    }, {
      value: 'always',
      text: _i18n.i18n.translate('xpack.search.queryRulesetDetail.queryRuleFlyout.operatorAlways', {
        defaultMessage: 'always'
      })
    }],
    onChange: e => {
      onChange({
        ...criteria,
        type: e.target.value
      });
    },
    value: criteria.type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.search.queryRulesetDetail.queryRuleFlyout.metadataEditorValuesLabel",
      defaultMessage: "Values",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 27
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.search.queryRulesetDetail.queryRuleFlyout.metadataEditorValuesTooltip', {
        defaultMessage: 'Values are used to match documents based on their query criteria. Values are ignored when the type is set to "always".'
      }),
      type: "question",
      color: "subdued",
      "aria-label": _i18n.i18n.translate('xpack.search.queryRulesetDetail.queryRuleFlyout.metadataEditorValuesTooltipLabel', {
        defaultMessage: 'Metadata values tooltip'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 237,
        columnNumber: 25
      }
    }))),
    isInvalid: !!(error !== null && error !== void 0 && error.values),
    isDisabled: criteria.type === 'always',
    error: error !== null && error !== void 0 && error.values ? error.values.message : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isInvalid: !!(error !== null && error !== void 0 && error.values),
    isDisabled: criteria.type === 'always',
    "data-test-subj": "searchQueryRulesQueryRuleMetadataEditorValues",
    fullWidth: true,
    "aria-label": _i18n.i18n.translate('xpack.search.queryRulesetDetail.queryRuleFlyout.metadataEditorValuesLabel', {
      defaultMessage: 'Select or create new values'
    }),
    selectedOptions: criteria === null || criteria === void 0 ? void 0 : (_criteria$values = criteria.values) === null || _criteria$values === void 0 ? void 0 : _criteria$values.map(value => ({
      label: value
    })),
    options: criteria !== null && criteria !== void 0 && criteria.values ? criteria.values.map(value => ({
      label: value
    })) : [],
    onCreateOption: newOption => {
      onChange({
        ...criteria,
        values: [...(criteria.values || []), newOption]
      });
    },
    onChange: selectedOptions => {
      onChange({
        ...criteria,
        values: selectedOptions.map(option => option.label)
      });
    },
    customOptionText: _i18n.i18n.translate('xpack.search.queryRulesetDetail.queryRuleFlyout.createNewMetadataValue', {
      defaultMessage: 'Create new metadata value: {newMetadataValue}',
      values: {
        newMetadataValue: 'New Metadata Value'
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 19
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "searchQueryRulesQueryRuleMetadataEditorDeleteButton",
    iconType: "minusInCircle",
    color: "danger",
    onClick: onRemove,
    "aria-label": _i18n.i18n.translate('xpack.search.queryRulesetDetail.queryRuleFlyout.removeCriteriaButton', {
      defaultMessage: 'Remove criteria'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 11
    }
  }))));
};
exports.QueryRuleMetadataEditor = QueryRuleMetadataEditor;