"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ViewCodeAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _i18nReact = require("@kbn/i18n-react");
var _types = require("../../types");
var _view_code_flyout = require("./view_code_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/view_code/view_code_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ViewCodeAction = ({
  selectedPageMode = _types.PlaygroundPageMode.chat
}) => {
  const {
    watch
  } = (0, _reactHookForm.useFormContext)();
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const selectedIndices = watch(_types.PlaygroundFormFields.indices);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showFlyout && /*#__PURE__*/_react.default.createElement(_view_code_flyout.ViewCodeFlyout, {
    selectedPageMode: selectedPageMode,
    onClose: () => setShowFlyout(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "export",
    onClick: () => setShowFlyout(true),
    disabled: !selectedIndices || (selectedIndices === null || selectedIndices === void 0 ? void 0 : selectedIndices.length) === 0,
    "data-test-subj": "viewCodeActionButton",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.export.actionButtonLabel",
    defaultMessage: "Export",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  })));
};
exports.ViewCodeAction = ViewCodeAction;