"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectIndicesFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _searchQueries = require("@kbn/search-queries");
var _use_indices_fields = require("../hooks/use_indices_fields");
var _use_source_indices_field = require("../hooks/use_source_indices_field");
var _use_query_indices = require("../hooks/use_query_indices");
var _select_indices = require("../utils/select_indices");
var _styles = require("./styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/select_indices_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IndicesErrorCallout = ({
  emptyIndices,
  isFieldsLoading
}) => {
  if (isFieldsLoading) return null;
  if (emptyIndices.length > 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      color: "danger",
      "data-test-subj": "NoIndicesFieldsMessage",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.searchPlayground.addDataSource.flyout.errorCallout",
        defaultMessage: "One or more indices have errors",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 51,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 7
      }
    });
  }
  return null;
};
const SelectIndicesFlyout = ({
  onClose
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const [query, setQuery] = (0, _react.useState)('');
  const {
    indices,
    isLoading: isIndicesLoading
  } = (0, _use_query_indices.useQueryIndices)({
    query
  });
  const {
    indices: selectedIndices,
    setIndices: setSelectedIndices
  } = (0, _use_source_indices_field.useSourceIndicesFields)();
  const [selectedTempIndices, setSelectedTempIndices] = (0, _react.useState)(selectedIndices);
  const {
    fields,
    isLoading: isFieldsLoading
  } = (0, _use_indices_fields.useIndicesFields)(selectedTempIndices);
  const {
    emptyIndices,
    disabledSave
  } = (0, _react.useMemo)(() => {
    var _emptyIndicesList$len;
    if (isFieldsLoading || selectedTempIndices.length === 0) {
      return {
        disabledSave: true,
        emptyIndices: []
      };
    }
    const emptyIndicesList = (0, _searchQueries.getIndicesWithNoSourceFields)(fields);
    return {
      disabledSave: ((_emptyIndicesList$len = emptyIndicesList === null || emptyIndicesList === void 0 ? void 0 : emptyIndicesList.length) !== null && _emptyIndicesList$len !== void 0 ? _emptyIndicesList$len : 0) > 0,
      emptyIndices: emptyIndicesList !== null && emptyIndicesList !== void 0 ? emptyIndicesList : []
    };
  }, [fields, isFieldsLoading, selectedTempIndices]);
  const indexOptions = (0, _react.useMemo)(() => indices.map((index, num) => {
    const option = {
      label: index,
      checked: selectedTempIndices.includes(index) ? 'on' : undefined,
      'data-test-subj': `sourceIndex-${num}`
    };
    if (emptyIndices.includes(index)) {
      option.append = /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        position: "top",
        content: _i18n.i18n.translate('xpack.searchPlayground.addDataSource.flyout.emptyIndexTooltip', {
          defaultMessage: 'No fields found in index'
        }),
        type: "warning",
        color: "danger",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 13
        }
      });
    } else if (selectedTempIndices.includes(index) && fields[index] && fields[index].source_fields.length > 0) {
      option.append = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.searchPlayground.addDataSource.flyout.indexFieldCount",
        defaultMessage: "{fieldCount, plural, one {# Field} other {# Fields}}",
        values: {
          fieldCount: fields[index].source_fields.length
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 13
        }
      });
    }
    return option;
  }), [indices, selectedTempIndices, emptyIndices, fields]);
  const handleSaveQuery = () => {
    setSelectedIndices(selectedTempIndices);
    onClose();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: "s",
    ownFocus: true,
    onClose: onClose,
    "data-test-subj": "selectIndicesFlyout",
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "data-test-subj": "indicesTable",
    searchable: true,
    height: "full",
    css: (0, _styles.AddDataFlyoutIndicesSelectable)(euiTheme),
    searchProps: {
      placeholder: _i18n.i18n.translate('xpack.searchPlayground.addDataSource.flyout.search.placeholder', {
        defaultMessage: 'Search'
      }),
      onChange: setQuery
    },
    options: indexOptions,
    onChange: (0, _select_indices.handleSelectOptions)(selectedTempIndices, setSelectedTempIndices),
    listProps: {
      showIcons: true,
      bordered: true,
      onFocusBadge: false
    },
    isLoading: isIndicesLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.addDataSource.flyout.title",
    defaultMessage: "Add data",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 15
    }
  }), search, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.setupPage.addDataSource.flyout.selectedCount",
    defaultMessage: "{selectedCount} selected",
    values: {
      selectedCount: selectedTempIndices.length
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 13
    }
  }), list)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(IndicesErrorCallout, {
    emptyIndices: emptyIndices,
    isFieldsLoading: isFieldsLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: onClose,
    flush: "left",
    "data-test-subj": "closeButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.addDataSource.flyout.closeButton",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: handleSaveQuery,
    "data-test-subj": "saveButton",
    fill: true,
    disabled: disabledSave,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.setupPage.addDataSource.flyout.addDataButton",
    defaultMessage: "Add data",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 15
    }
  }))))));
};
exports.SelectIndicesFlyout = SelectIndicesFlyout;