"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedPlaygroundInvalidStateModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/saved_playground/invalid_state_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var InvalidPlaygroundType = /*#__PURE__*/function (InvalidPlaygroundType) {
  InvalidPlaygroundType[InvalidPlaygroundType["MissingIndices"] = 0] = "MissingIndices";
  InvalidPlaygroundType[InvalidPlaygroundType["MissingModel"] = 1] = "MissingModel";
  return InvalidPlaygroundType;
}(InvalidPlaygroundType || {});
const SavedPlaygroundInvalidStateModal = ({
  errors,
  onClose
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const errorsTypes = (0, _react.useMemo)(() => {
    const eTypes = new Set();
    if (errors.missingIndices.length > 0) {
      eTypes.add(InvalidPlaygroundType.MissingIndices);
    }
    if (errors.missingModel !== undefined) {
      eTypes.add(InvalidPlaygroundType.MissingModel);
    }
    return eTypes;
  }, [errors]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-labelledby": modalTitleId,
    onClose: onClose,
    "data-test-subj": "edit-playground-name-modal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, errorsTypes.has(InvalidPlaygroundType.MissingIndices) && errorsTypes.has(InvalidPlaygroundType.MissingModel) ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.savedPlayground.invalidPlayground.title",
    defaultMessage: "Invalid playground values",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 13
    }
  }) : errorsTypes.has(InvalidPlaygroundType.MissingModel) ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.savedPlayground.invalidModelConnector.title",
    defaultMessage: "AI Connector not found",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.savedPlayground.invalidDataSources.title",
    defaultMessage: "Invalid data sources",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, errorsTypes.has(InvalidPlaygroundType.MissingIndices) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.savedPlayground.invalidDataSources.description",
    defaultMessage: "Some indices were not found. These indices will be removed from your data source selection for this playground.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 15
    }
  }, errors.missingIndices.map(index => /*#__PURE__*/_react.default.createElement("li", {
    key: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 19
    }
  }, index)))), errorsTypes.has(InvalidPlaygroundType.MissingModel) && /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.savedPlayground.invalidModelConnector.description",
    defaultMessage: "The selected LLM connector for this playground was not found. Please select a different LLM for use with this playground.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "searchPlaygroundInvalidSavedStateModalCloseButton",
    onClick: onClose,
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.savedPlayground.invalidPlaygroundModal.close",
    defaultMessage: "OK",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }))));
};
exports.SavedPlaygroundInvalidStateModal = SavedPlaygroundInvalidStateModal;