"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_YOUR_MODELS_LINK = exports.UNABLE_TO_CREATE_INFERENCE_ENDPOINT = exports.TRAINED_MODELS_STAT_GATHER_FAILED = exports.TASK_TYPE = exports.SERVICE_PROVIDER = exports.MANAGE_INFERENCE_ENDPOINTS_LABEL = exports.INFERENCE_ENDPOINT_ALREADY_EXISTS = exports.INFERENCE_ENDPOINTS_TABLE_CAPTION = exports.FORBIDDEN_TO_ACCESS_TRAINED_MODELS = exports.ERROR_TITLE = exports.ENDPOINT_VIEW_ACTION_LABEL = exports.ENDPOINT_DELETE_ACTION_LABEL = exports.ENDPOINT_CREATION_FAILED = exports.ENDPOINT_COPY_SUCCESS = exports.ENDPOINT_COPY_ID_ACTION_LABEL = exports.ENDPOINT_ADDED_SUCCESS_DESCRIPTION = exports.ENDPOINT_ADDED_SUCCESS = exports.ENDPOINT = exports.EIS_DOCUMENTATION_LINK = exports.CANCEL = exports.BREADCRUMB_RELEVANCE = exports.BREADCRUMB_INFERENCE_ENDPOINTS = exports.API_DOCUMENTATION_LINK = exports.ADD_ENDPOINT_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CANCEL = exports.CANCEL = _i18n.i18n.translate('xpack.searchInferenceEndpoints.cancel', {
  defaultMessage: 'Cancel'
});
const MANAGE_INFERENCE_ENDPOINTS_LABEL = exports.MANAGE_INFERENCE_ENDPOINTS_LABEL = _i18n.i18n.translate('xpack.searchInferenceEndpoints.allInferenceEndpoints.description', {
  defaultMessage: 'Inference endpoints streamline the deployment and management of machine\nlearning models in Elasticsearch. Set up and manage NLP tasks using unique\nendpoints, to build AI-powered search.'
});
const VIEW_YOUR_MODELS_LINK = exports.VIEW_YOUR_MODELS_LINK = _i18n.i18n.translate('xpack.searchInferenceEndpoints.viewYourModels', {
  defaultMessage: 'ML Trained Models'
});
const EIS_DOCUMENTATION_LINK = exports.EIS_DOCUMENTATION_LINK = _i18n.i18n.translate('xpack.searchInferenceEndpoints.eisDocumentationLink', {
  defaultMessage: 'Elastic Inference Service'
});
const API_DOCUMENTATION_LINK = exports.API_DOCUMENTATION_LINK = _i18n.i18n.translate('xpack.searchInferenceEndpoints.apiDocumentationLink', {
  defaultMessage: 'API Documentation'
});
const ADD_ENDPOINT_LABEL = exports.ADD_ENDPOINT_LABEL = _i18n.i18n.translate('xpack.searchInferenceEndpoints.addConnectorButtonLabel', {
  defaultMessage: 'Add endpoint'
});
const ERROR_TITLE = exports.ERROR_TITLE = _i18n.i18n.translate('xpack.searchInferenceEndpoints.inferenceId.errorTitle', {
  defaultMessage: 'Error adding inference endpoint'
});
const UNABLE_TO_CREATE_INFERENCE_ENDPOINT = exports.UNABLE_TO_CREATE_INFERENCE_ENDPOINT = _i18n.i18n.translate('xpack.searchInferenceEndpoints.inferenceFlyoutWrapperComponent.unableTocreateInferenceEndpointError', {
  defaultMessage: 'Unable to create an inference endpoint.'
});
const INFERENCE_ENDPOINT_ALREADY_EXISTS = exports.INFERENCE_ENDPOINT_ALREADY_EXISTS = _i18n.i18n.translate('xpack.searchInferenceEndpoints.inferenceFlyoutWrapperComponent.inferenceEndpointAlreadyExistsError', {
  defaultMessage: 'Inference endpoint id already exists'
});
const FORBIDDEN_TO_ACCESS_TRAINED_MODELS = exports.FORBIDDEN_TO_ACCESS_TRAINED_MODELS = _i18n.i18n.translate('xpack.searchInferenceEndpoints.inferenceFlyoutWrapperComponent.forbiddenToAccessTrainedModelsError', {
  defaultMessage: 'Forbidden to access trained models'
});
const ENDPOINT_ADDED_SUCCESS = exports.ENDPOINT_ADDED_SUCCESS = _i18n.i18n.translate('xpack.searchInferenceEndpoints.actions.endpointAddedSuccess', {
  defaultMessage: 'Endpoint added'
});
const ENDPOINT_CREATION_FAILED = exports.ENDPOINT_CREATION_FAILED = _i18n.i18n.translate('xpack.searchInferenceEndpoints.actions.endpointAddedFailure', {
  defaultMessage: 'Endpoint creation failed'
});
const ENDPOINT_ADDED_SUCCESS_DESCRIPTION = endpointId => _i18n.i18n.translate('xpack.searchInferenceEndpoints.actions.endpointAddedSuccessDescription', {
  defaultMessage: 'The inference endpoint "{endpointId}" was added.',
  values: {
    endpointId
  }
});
exports.ENDPOINT_ADDED_SUCCESS_DESCRIPTION = ENDPOINT_ADDED_SUCCESS_DESCRIPTION;
const ENDPOINT = exports.ENDPOINT = _i18n.i18n.translate('xpack.searchInferenceEndpoints.endpoint', {
  defaultMessage: 'Endpoint'
});
const SERVICE_PROVIDER = exports.SERVICE_PROVIDER = _i18n.i18n.translate('xpack.searchInferenceEndpoints.serviceProvider', {
  defaultMessage: 'Service'
});
const TASK_TYPE = exports.TASK_TYPE = _i18n.i18n.translate('xpack.searchInferenceEndpoints.taskType', {
  defaultMessage: 'Type'
});
const TRAINED_MODELS_STAT_GATHER_FAILED = exports.TRAINED_MODELS_STAT_GATHER_FAILED = _i18n.i18n.translate('xpack.searchInferenceEndpoints.actions.trainedModelsStatGatherFailed', {
  defaultMessage: 'Failed to retrieve trained model statistics'
});
const BREADCRUMB_RELEVANCE = exports.BREADCRUMB_RELEVANCE = _i18n.i18n.translate('xpack.searchInferenceEndpoints.breadcrumbs.relevance', {
  defaultMessage: 'Relevance'
});
const BREADCRUMB_INFERENCE_ENDPOINTS = exports.BREADCRUMB_INFERENCE_ENDPOINTS = _i18n.i18n.translate('xpack.searchInferenceEndpoints.breadcrumbs.inferenceEndpoints', {
  defaultMessage: 'Inference endpoints'
});
const ENDPOINT_COPY_SUCCESS = inferenceId => _i18n.i18n.translate('xpack.searchInferenceEndpoints.actions.copyIDSuccess', {
  defaultMessage: 'Inference endpoint ID {inferenceId} copied',
  values: {
    inferenceId
  }
});
exports.ENDPOINT_COPY_SUCCESS = ENDPOINT_COPY_SUCCESS;
const ENDPOINT_COPY_ID_ACTION_LABEL = exports.ENDPOINT_COPY_ID_ACTION_LABEL = _i18n.i18n.translate('xpack.searchInferenceEndpoints.actions.copyID', {
  defaultMessage: 'Copy endpoint ID'
});
const ENDPOINT_DELETE_ACTION_LABEL = exports.ENDPOINT_DELETE_ACTION_LABEL = _i18n.i18n.translate('xpack.searchInferenceEndpoints.actions.deleteEndpoint', {
  defaultMessage: 'Delete endpoint'
});
const ENDPOINT_VIEW_ACTION_LABEL = exports.ENDPOINT_VIEW_ACTION_LABEL = _i18n.i18n.translate('xpack.searchInferenceEndpoints.actions.viewEndpooint', {
  defaultMessage: 'View endpoint'
});
const INFERENCE_ENDPOINTS_TABLE_CAPTION = exports.INFERENCE_ENDPOINTS_TABLE_CAPTION = _i18n.i18n.translate('xpack.searchInferenceEndpoints.table.caption', {
  defaultMessage: 'Inference endpoints table'
});