"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateElserMappingsModal = UpdateElserMappingsModal;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _utils = require("./utils");
var _use_kibana = require("../../hooks/use_kibana");
var _use_update_mappings = require("../../hooks/api/use_update_mappings");
var _doc_links = require("../../../common/doc_links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_indices/public/components/update_elser_mappings/update_elser_mappings_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function UpdateElserMappingsModal({
  indexName,
  setIsModalOpen,
  hasUpdatePrivileges,
  mappings
}) {
  const {
    notifications
  } = (0, _use_kibana.useKibana)().services;
  const {
    updateIndexMappings,
    isLoading
  } = (0, _use_update_mappings.useUpdateMappings)();
  const [options, setOptions] = (0, _react.useState)([]);
  const isApplyDisabled = hasUpdatePrivileges === false || options.every(o => o.checked !== 'on');
  const buildElserOptions = (0, _react.useCallback)(flattenedMappings => {
    const elserMappings = Object.values(flattenedMappings).filter(_utils.isElserOnMlNodeSemanticField);
    return elserMappings.map(field => ({
      label: field.path.join('.'),
      name: field.source.name,
      key: field.id,
      prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
        iconType: "tokenSemanticText",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 18
        }
      }),
      append: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 17
        }
      }, field.source.inference_id)
    }));
  }, []);
  const renderMappingOption = (0, _react.useCallback)(option => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 9
      }
    }, option.name), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      className: "eui-displayBlock",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("small", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 11
      }
    }, option.label || '')));
  }, []);
  const handleApply = (0, _react.useCallback)(async () => {
    const selectedOptions = options.filter(option => option.checked === 'on');
    const selectedFields = (0, _utils.prepareFieldsForEisUpdate)(selectedOptions, mappings);
    const denormalizedFields = (0, _utils.deNormalize)(selectedFields);
    updateIndexMappings({
      indexName,
      fields: denormalizedFields
    }, {
      onSuccess: () => {
        notifications.toasts.addSuccess({
          title: _i18n.i18n.translate('xpack.searchIndices.updateElserMappingsModal.successfullyUpdatedIndexMappingsTitle', {
            defaultMessage: 'Mappings updated'
          }),
          text: _i18n.i18n.translate('xpack.searchIndices.updateElserMappingsModal.successfullyUpdatedIndexMappingsText', {
            defaultMessage: 'Your index mappings have been updated.'
          })
        });
        setIsModalOpen(false);
      },
      onError: error => {
        var _ref, _error$body$message, _error$body;
        const fallbackErrorMessage = _i18n.i18n.translate('xpack.searchIndices.updateElserMappingsModal.error.defaultMessage', {
          defaultMessage: 'Mappings could not be updated. Please try again.'
        });
        const errorMessage = (_ref = (_error$body$message = error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error === null || error === void 0 ? void 0 : error.message) !== null && _ref !== void 0 ? _ref : fallbackErrorMessage;
        notifications.toasts.addError(new Error(errorMessage), {
          title: _i18n.i18n.translate('xpack.searchIndices.updateElserMappingsModal.error.title', {
            defaultMessage: 'Error updating mappings'
          })
        });
      }
    });
  }, [indexName, options, notifications.toasts, setIsModalOpen, updateIndexMappings, mappings]);
  (0, _react.useEffect)(() => {
    const elserOptions = buildElserOptions(mappings);
    setOptions(elserOptions);
  }, [mappings, buildElserOptions]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    style: {
      width: 600
    },
    "aria-labelledby": _i18n.i18n.translate('xpack.searchIndices.updateElserMappingsModal.ariaLabelledBy', {
      defaultMessage: 'Update mappings to ELSER on EIS modal'
    }),
    onClose: () => setIsModalOpen(false),
    "data-test-subj": "updateElserMappingsModal",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.searchIndices.updateElserMappingsModal.title', {
    defaultMessage: 'Update mappings to ELSER on EIS'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.searchIndices.updateElserMappingsModal.costsTransparency', {
    defaultMessage: 'Performing inference and other ML tasks using the Elastic Inference Service (EIS) will incur token-based costs.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "updateElserMappingsModalLearnMoreLink",
    "data-telemetry-id": "indexDetailsData-updateElserMappingsModal-learnMore-link",
    href: _doc_links.docLinks.elasticInferenceServicePricing,
    target: "_blank",
    external: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.searchIndices.updateElserMappingsModal.learnMoreLink', {
    defaultMessage: 'Learn more'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "data-test-subj": "updateElserMappingsSelect",
    "aria-label": _i18n.i18n.translate('xpack.searchIndices.updateElserMappingsModal.select', {
      defaultMessage: 'Select ELSER mappings'
    }),
    options: options,
    listProps: {
      bordered: true,
      isVirtualized: true,
      rowHeight: 50
    },
    onChange: newOptions => setOptions(newOptions),
    renderOption: renderMappingOption,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 9
    }
  }, list => list), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.searchIndices.updateElserMappingsModal.updateConditions', {
    defaultMessage: 'Only fields using .elser-2-elasticsearch can be updated to use .elser-2-elastic on the Elastic Inference Service.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "UpdateElserMappingsModalCancelBtn",
    "data-telemetry-id": "indexDetailsData-updateElserMappingsModal-cancel-btn",
    onClick: () => setIsModalOpen(false),
    "aria-label": _i18n.i18n.translate('xpack.searchIndices.updateElserMappingsModal.cancelButtonAriaLabel', {
      defaultMessage: 'Cancel and close modal'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.searchIndices.updateElserMappingsModal.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: handleApply,
    isLoading: isLoading,
    "data-test-subj": "UpdateElserMappingsModalApplyBtn",
    "data-telemetry-id": "indexDetailsData-updateElserMappingsModal-apply-btn",
    isDisabled: isApplyDisabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.searchIndices.updateElserMappingsModal.applyButton', {
    defaultMessage: 'Apply'
  })))));
}