"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatsItemStyle = exports.StatsGridContainerStyle = exports.QuickStatsPanelStyle = exports.AliasesContentStyle = void 0;
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QuickStatsPanelStyle = euiTheme => (0, _react.css)`
  background: ${euiTheme.colors.lightestShade};
  overflow: hidden;
`;
exports.QuickStatsPanelStyle = QuickStatsPanelStyle;
const StatsGridContainerStyle = exports.StatsGridContainerStyle = (0, _react.css)`
  display: grid;
  grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
`;
const StatsItemStyle = euiTheme => (0, _react.css)`
  border: ${euiTheme.border.thin};
  min-width: 250px;
`;
exports.StatsItemStyle = StatsItemStyle;
const AliasesContentStyle = exports.AliasesContentStyle = (0, _react.css)`
  max-height: 100px;
`;