"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QuickStats = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ai_search_stat = require("./ai_search_stat");
var _aliases_quick_stat = require("./aliases_quick_stat");
var _stateful_document_count_stat = require("./stateful_document_count_stat");
var _stateful_storage_stat = require("./stateful_storage_stat");
var _index_status_stat = require("./index_status_stat");
var _quick_stats_container = require("./quick_stats_container");
var _mappings_convertor = require("./mappings_convertor");
var _stateless_document_cout_stat = require("./stateless_document_cout_stat");
var _stateless_quick_stats = require("./stateless_quick_stats");
var _styles = require("./styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_indices/public/components/quick_stats/quick_stats.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const QuickStats = ({
  index,
  mappings,
  indexDocuments,
  isStateless
}) => {
  var _indexDocuments$resul;
  const [open, setOpen] = (0, _react.useState)(false);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    mappingStats,
    vectorFieldCount
  } = (0, _react.useMemo)(() => {
    const stats = (0, _mappings_convertor.countVectorBasedTypesFromMappings)(mappings);
    const vectorFields = stats.sparse_vector + stats.dense_vector + stats.semantic_text;
    return {
      mappingStats: stats,
      vectorFieldCount: vectorFields
    };
  }, [mappings]);
  const stats = isStateless ? [/*#__PURE__*/_react.default.createElement(_stateless_document_cout_stat.StatelessDocumentCountStat, {
    index: index,
    documentCount: (_indexDocuments$resul = indexDocuments === null || indexDocuments === void 0 ? void 0 : indexDocuments.results._meta.page.total) !== null && _indexDocuments$resul !== void 0 ? _indexDocuments$resul : 0,
    open: open,
    setOpen: setOpen,
    key: "statelessDocumentCountStat",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }), ...(Array.isArray(index.aliases) && index.aliases.length > 0 ? [/*#__PURE__*/_react.default.createElement(_aliases_quick_stat.AliasesStat, {
    aliases: index.aliases,
    open: open,
    setOpen: setOpen,
    key: "aliasesStat",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 15
    }
  })] : []), /*#__PURE__*/_react.default.createElement(_ai_search_stat.AISearchQuickStat, {
    mappingStats: mappingStats,
    vectorFieldCount: vectorFieldCount,
    open: open,
    setOpen: setOpen,
    key: "aISearchQuickStat",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  })] : [/*#__PURE__*/_react.default.createElement(_index_status_stat.IndexStatusStat, {
    index: index,
    open: open,
    setOpen: setOpen,
    key: "indexStatusStat",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_stateful_storage_stat.StatefulIndexStorageStat, {
    index: index,
    open: open,
    setOpen: setOpen,
    key: "statefulIndexStorageStat",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_stateful_document_count_stat.StatefulDocumentCountStat, {
    open: open,
    setOpen: setOpen,
    index: index,
    mappingStats: mappingStats,
    key: "statefulDocumentCountStat",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }), ...(Array.isArray(index.aliases) && index.aliases.length > 0 ? [/*#__PURE__*/_react.default.createElement(_aliases_quick_stat.AliasesStat, {
    aliases: index.aliases,
    open: open,
    setOpen: setOpen,
    key: "aliasesStat",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 15
    }
  })] : []), /*#__PURE__*/_react.default.createElement(_ai_search_stat.AISearchQuickStat, {
    mappingStats: mappingStats,
    vectorFieldCount: vectorFieldCount,
    open: open,
    setOpen: setOpen,
    key: "aISearchQuickStat",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  })];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    "data-test-subj": "quickStats",
    hasShadow: false,
    css: (0, _styles.QuickStatsPanelStyle)(euiTheme),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 5
    }
  }, isStateless ? /*#__PURE__*/_react.default.createElement(_stateless_quick_stats.StatelessQuickStats, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }, stats) : /*#__PURE__*/_react.default.createElement(_quick_stats_container.QuickStatsContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, stats));
};
exports.QuickStats = QuickStats;