"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexDetailsData = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _searchApiPanels = require("@kbn/search-api-panels");
var _constants = require("@kbn/deeplinks-management/constants");
var _use_kibana = require("../../hooks/use_kibana");
var _use_index_mappings = require("../../hooks/api/use_index_mappings");
var _index_documents = require("../index_documents/index_documents");
var _details_search_example = require("./details_search_example");
var _doc_links = require("../../../common/doc_links");
var _update_elser_mappings_modal = require("../update_elser_mappings/update_elser_mappings_modal");
var _utils = require("../update_elser_mappings/utils");
var _use_license = require("../../hooks/use_license");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_indices/public/components/indices/details_page_data.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IndexDetailsData = ({
  indexName,
  indexDocuments,
  isInitialLoading,
  navigateToPlayground,
  userPrivileges
}) => {
  var _indexDocuments$resul, _indexDocuments$resul2, _ref;
  const {
    application,
    cloud
  } = (0, _use_kibana.useKibana)().services;
  const {
    data: mappingData
  } = (0, _use_index_mappings.useIndexMapping)(indexName);
  const {
    isAtLeastEnterprise
  } = (0, _use_license.useLicense)();
  const [isUpdatingElserMappings, setIsUpdatingElserMappings] = (0, _react.useState)(false);
  const documents = (_indexDocuments$resul = indexDocuments === null || indexDocuments === void 0 ? void 0 : (_indexDocuments$resul2 = indexDocuments.results) === null || _indexDocuments$resul2 === void 0 ? void 0 : _indexDocuments$resul2.data) !== null && _indexDocuments$resul !== void 0 ? _indexDocuments$resul : [];
  const shouldShowEisUpdateCallout = (_ref = (cloud === null || cloud === void 0 ? void 0 : cloud.isCloudEnabled) && (isAtLeastEnterprise() || (cloud === null || cloud === void 0 ? void 0 : cloud.isServerlessEnabled))) !== null && _ref !== void 0 ? _ref : false;
  const fieldsForUpdate = (0, _react.useMemo)(() => {
    var _mappingData$mappings;
    const properties = mappingData === null || mappingData === void 0 ? void 0 : (_mappingData$mappings = mappingData.mappings) === null || _mappingData$mappings === void 0 ? void 0 : _mappingData$mappings.properties;
    if (properties && Object.keys(properties).length > 0) {
      const flattenedMappings = (0, _utils.flattenMappings)(properties);
      if ((0, _utils.hasElserOnMlNodeSemanticTextField)(flattenedMappings)) {
        return flattenedMappings;
      }
    }
    // Return undefined when there are no ELSER fields on ML node to update
    return undefined;
  }, [mappingData]);
  if (isInitialLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasBorder: false,
      hasShadow: false,
      paddingSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
      size: "xs",
      color: "primary",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_searchApiPanels.EisCloudConnectPromoCallout, {
    promoId: "indexDetailsData",
    isSelfManaged: !(cloud !== null && cloud !== void 0 && cloud.isCloudEnabled),
    direction: "row",
    navigateToApp: () => application.navigateToApp(_constants.CLOUD_CONNECT_NAV_ID, {
      openInNewTab: true
    }),
    addSpacer: "top",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }), fieldsForUpdate && /*#__PURE__*/_react.default.createElement(_searchApiPanels.EisUpdateCallout, {
    ctaLink: _doc_links.docLinks.elasticInferenceService,
    promoId: "indexDetailsData",
    shouldShowEisUpdateCallout: shouldShowEisUpdateCallout,
    handleOnClick: () => setIsUpdatingElserMappings(true),
    direction: "row",
    hasUpdatePrivileges: userPrivileges === null || userPrivileges === void 0 ? void 0 : userPrivileges.privileges.canManageIndex,
    addSpacer: "top",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }), isUpdatingElserMappings && fieldsForUpdate && /*#__PURE__*/_react.default.createElement(_update_elser_mappings_modal.UpdateElserMappingsModal, {
    indexName: indexName,
    setIsModalOpen: setIsUpdatingElserMappings,
    hasUpdatePrivileges: userPrivileges === null || userPrivileges === void 0 ? void 0 : userPrivileges.privileges.canManageIndex,
    mappings: fieldsForUpdate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }, documents.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_details_search_example.IndexSearchExample, {
    indexName: indexName,
    documents: documents,
    mappings: mappingData,
    navigateToPlayground: navigateToPlayground,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_index_documents.IndexDocuments, {
    indexName: indexName,
    documents: documents,
    mappings: mappingData,
    userPrivileges: userPrivileges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  })))));
};
exports.IndexDetailsData = IndexDetailsData;