"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStats = void 0;
var _reactQuery = require("@kbn/react-query");
var _use_kibana = require("../use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStats = () => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const queryResult = (0, _reactQuery.useQuery)({
    queryKey: ['fetchSizeStats'],
    queryFn: async () => {
      const response = await http.get('/internal/search_homepage/stats');
      return {
        documents: response.sizeStats.documents,
        size: response.sizeStats.size
      };
    }
  });
  return queryResult;
};
exports.useStats = useStats;