"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAgentCount = void 0;
var _reactQuery = require("@kbn/react-query");
var _use_kibana = require("../use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAgentCount = () => {
  var _data$tools, _data$agents;
  const {
    services: {
      onechat
    }
  } = (0, _use_kibana.useKibana)();
  const {
    data,
    isLoading,
    isError
  } = (0, _reactQuery.useQuery)({
    queryKey: ['fetchAgentCount'],
    queryFn: async () => {
      var _agents$length, _tools$length;
      const [agents, tools] = await Promise.all([onechat === null || onechat === void 0 ? void 0 : onechat.agents.list(), onechat === null || onechat === void 0 ? void 0 : onechat.tools.list()]);
      return {
        agents: (_agents$length = agents === null || agents === void 0 ? void 0 : agents.length) !== null && _agents$length !== void 0 ? _agents$length : 0,
        tools: (_tools$length = tools === null || tools === void 0 ? void 0 : tools.length) !== null && _tools$length !== void 0 ? _tools$length : 0
      };
    }
  });
  return {
    tools: (_data$tools = data === null || data === void 0 ? void 0 : data.tools) !== null && _data$tools !== void 0 ? _data$tools : 0,
    agents: (_data$agents = data === null || data === void 0 ? void 0 : data.agents) !== null && _data$agents !== void 0 ? _data$agents : 0,
    isLoading,
    isError
  };
};
exports.useAgentCount = useAgentCount;