"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectToElasticsearch = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _searchSharedUi = require("@kbn/search-shared-ui");
var _connection_details = require("@kbn/cloud/connection_details");
var _searchApiKeysComponents = require("@kbn/search-api-keys-components");
var _use_elasticsearch_url = require("../../hooks/use_elasticsearch_url");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_homepage/public/components/search_homepage/connect_to_elasticsearch.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectToElasticsearch = () => {
  const elasticsearchUrl = (0, _use_elasticsearch_url.useElasticsearchUrl)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    status
  } = (0, _searchApiKeysComponents.useSearchApiKey)();
  const hasAPIKeyManagePermissions = (0, _react.useMemo)(() => {
    return status !== _searchApiKeysComponents.Status.showUserPrivilegesError;
  }, [status]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.searchHomepage.connectToElasticsearch.p.endpointLabel', {
    defaultMessage: 'Endpoint:'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_searchSharedUi.FormInfoField, {
    value: elasticsearchUrl,
    copyValue: elasticsearchUrl,
    dataTestSubj: "endpointValueField",
    copyValueDataTestSubj: "copyEndpointButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)({
      borderLeft: euiTheme.colors.borderBaseSubdued
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "searchHomepageConnectToElasticsearchApiKeysButton",
    color: "text",
    iconType: "plusInCircle",
    size: "s",
    onClick: () => (0, _connection_details.openWiredConnectionDetails)({
      props: {
        options: {
          defaultTabId: 'apiKeys'
        }
      }
    }),
    disabled: !hasAPIKeyManagePermissions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchHomepage.connectToElasticsearch.apiKeysButtonEmptyLabel",
    defaultMessage: "API keys",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    display: "base",
    size: "s",
    iconSize: "m",
    iconType: "plugs",
    onClick: () => (0, _connection_details.openWiredConnectionDetails)(),
    "data-test-subj": "searchHomepageConnectToElasticsearchConnectionDetailsButton",
    color: "text",
    "aria-label": _i18n.i18n.translate('xpack.searchHomepage.searchHomepagePage.euiButtonIcon.connectionDetailsPressToLabel', {
      defaultMessage: 'Show connection details for connecting to the Elasticsearch API'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  })));
};
exports.ConnectToElasticsearch = ConnectToElasticsearch;