"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BodyLinks = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _doc_links = require("../../../common/doc_links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_homepage/public/components/search_homepage/body_links.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const BodyLink = ({
  title,
  description,
  link,
  category
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    css: (0, _react2.css)({
      minHeight: `${euiTheme.base * 12}px`
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, category && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "success",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 15
    }
  }, category)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 15
    }
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 15
    }
  }, description))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, Array.isArray(link) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, link.map((l, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: `body-link-map-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "searchHomepageBodyLinkLink",
    external: true,
    href: l.href,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 17
    }
  }, l.text)))) : /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "searchHomepageBodyLinkLink",
    external: true,
    href: link.href,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, link.text)));
};
const BodyLinks = () => {
  const BODY_LINKS = [{
    title: _i18n.i18n.translate('xpack.searchHomepage.bodyLinks.askAnExpert.title', {
      defaultMessage: 'Ask an Elastic Expert'
    }),
    description: _i18n.i18n.translate('xpack.searchHomepage.bodyLinks.askAnExpert.description', {
      defaultMessage: 'Our team of customer engineers to discuss your specific needs and offer personalized guidance to help make the most of your Elastic trial.'
    }),
    link: {
      href: _doc_links.docLinks.customerEngineerRequestForm,
      text: _i18n.i18n.translate('xpack.searchHomepage.bodyLinks.askAnExpert.link.text', {
        defaultMessage: 'Contact customer engineering'
      })
    }
  }, {
    title: _i18n.i18n.translate('xpack.searchHomepage.bodyLinks.elasticTraining.title', {
      defaultMessage: 'Certified mastery of Elastic'
    }),
    description: _i18n.i18n.translate('xpack.searchHomepage.bodyLinks.elasticTraining.description', {
      defaultMessage: 'Unlock the full potential of Elastic through expert-led training, interactive labs, comprehensive certification programs, and flexible on-demand learning.'
    }),
    link: {
      href: _doc_links.docLinks.elasticTraining,
      text: _i18n.i18n.translate('xpack.searchHomepage.bodyLinks.elasticTraining.linkText', {
        defaultMessage: 'Elastic Training'
      })
    }
  }, {
    title: _i18n.i18n.translate('xpack.searchHomepage.bodyLinks.elasticDocumentation.title', {
      defaultMessage: 'Elasticsearch Documentation'
    }),
    description: _i18n.i18n.translate('xpack.searchHomepage.bodyLinks.elasticDocumentation.description', {
      defaultMessage: 'A range of executable Python notebooks available to easily test features in a virtual environment.'
    }),
    link: {
      href: _doc_links.docLinks.elasticsearchDocs,
      text: _i18n.i18n.translate('xpack.searchHomepage.bodyLinks.elasticDocumentation.link.text', {
        defaultMessage: 'View documentation'
      })
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 3,
    gutterSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 5
    }
  }, BODY_LINKS.map((bodyLink, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `bodylink-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(BodyLink, (0, _extends2.default)({}, bodyLink, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  })))));
};
exports.BodyLinks = BodyLinks;