"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchGettingStartedPlugin = void 0;
var _public = require("@kbn/core/public");
var _reactQuery = require("@kbn/react-query");
var _common = require("../common");
var _doc_links = require("./common/doc_links");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class SearchGettingStartedPlugin {
  setup(core, deps) {
    const queryClient = new _reactQuery.QueryClient({});
    core.application.register({
      id: _common.PLUGIN_ID,
      appRoute: _common.PLUGIN_PATH,
      title: _common.PLUGIN_NAME,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      euiIconType: 'logoElasticsearch',
      async mount({
        element,
        history
      }) {
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        const [coreStart, depsStart] = await core.getStartServices();
        _doc_links.docLinks.setDocLinks(coreStart.docLinks.links);
        const services = {
          ...depsStart,
          history,
          usageCollection: depsStart.usageCollection
        };
        return renderApp(coreStart, services, element, queryClient);
      },
      order: 1,
      visibleIn: ['globalSearch', 'sideNav']
    });
    return {};
  }
  start(core) {
    return {};
  }
  stop() {}
}
exports.SearchGettingStartedPlugin = SearchGettingStartedPlugin;