"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateFilteringDraft = void 0;
var _fetch_connectors = require("./fetch_connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const updateFilteringDraft = async (client, connectorId, {
  advancedSnippet,
  filteringRules
}) => {
  const now = new Date().toISOString();
  const parsedAdvancedSnippet = advancedSnippet ? JSON.parse(advancedSnippet) : {};
  const parsedFilteringRules = filteringRules.map(filteringRule => ({
    ...filteringRule,
    created_at: filteringRule.created_at ? filteringRule.created_at : now,
    updated_at: now
  }));
  const draft = {
    advanced_snippet: {
      created_at: now,
      updated_at: now,
      value: parsedAdvancedSnippet
    },
    rules: parsedFilteringRules
  };
  const updateDraftFilteringResult = await client.transport.request({
    method: 'PUT',
    path: `/_connector/${connectorId}/_filtering`,
    body: draft
  });
  if (updateDraftFilteringResult.result === 'updated') {
    var _connector$filtering, _connector$filtering$;
    const connector = await (0, _fetch_connectors.fetchConnectorById)(client, connectorId);
    return connector === null || connector === void 0 ? void 0 : (_connector$filtering = connector.filtering) === null || _connector$filtering === void 0 ? void 0 : (_connector$filtering$ = _connector$filtering[0]) === null || _connector$filtering$ === void 0 ? void 0 : _connector$filtering$.draft;
  }
  return undefined;
};
exports.updateFilteringDraft = updateFilteringDraft;