"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagsRequestHandlerContext = void 0;
var _services = require("./services");
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var _client = /*#__PURE__*/new WeakMap();
var _assignmentService = /*#__PURE__*/new WeakMap();
class TagsRequestHandlerContext {
  constructor(request, coreContext, security) {
    _classPrivateFieldInitSpec(this, _client, void 0);
    _classPrivateFieldInitSpec(this, _assignmentService, void 0);
    this.request = request;
    this.coreContext = coreContext;
    this.security = security;
  }
  get tagsClient() {
    if (_classPrivateFieldGet(_client, this) == null) {
      _classPrivateFieldSet(_client, this, new _services.TagsClient({
        client: this.coreContext.savedObjects.client
      }));
    }
    return _classPrivateFieldGet(_client, this);
  }
  get assignmentService() {
    if (_classPrivateFieldGet(_assignmentService, this) == null) {
      var _this$security;
      _classPrivateFieldSet(_assignmentService, this, new _services.AssignmentService({
        request: this.request,
        client: this.coreContext.savedObjects.client,
        typeRegistry: this.coreContext.savedObjects.typeRegistry,
        authorization: (_this$security = this.security) === null || _this$security === void 0 ? void 0 : _this$security.authz
      }));
    }
    return _classPrivateFieldGet(_assignmentService, this);
  }
}
exports.TagsRequestHandlerContext = TagsRequestHandlerContext;