"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createIndex = void 0;
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createIndex = async ({
  esClient,
  indexName,
  mappings,
  legacySemanticText,
  log,
  elserInferenceId = _common.internalElserInferenceId,
  isServerless = false,
  abortController
}) => {
  log.debug(`Creating index ${indexName}`);
  overrideInferenceId(mappings, elserInferenceId);
  await esClient.indices.create({
    index: indexName,
    mappings,
    settings: !isServerless ? {
      auto_expand_replicas: '0-1',
      'index.mapping.semantic_text.use_legacy_format': legacySemanticText
    } : undefined
  }, {
    signal: abortController === null || abortController === void 0 ? void 0 : abortController.signal
  });
};
exports.createIndex = createIndex;
const overrideInferenceId = (mappings, inferenceId) => {
  const recursiveOverride = current => {
    if ('type' in current && current.type === 'semantic_text') {
      current.inference_id = inferenceId;
    }
    if ('properties' in current && current.properties) {
      for (const prop of Object.values(current.properties)) {
        recursiveOverride(prop);
      }
    }
  };
  recursiveOverride(mappings);
};