"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchArtifactVersions = void 0;
var _productDocCommon = require("@kbn/product-doc-common");
var fs = _interopRequireWildcard(require("fs"));
var _nodeFetch = _interopRequireDefault(require("node-fetch"));
var Path = _interopRequireWildcard(require("path"));
var _url = require("url");
var _xml2js = require("xml2js");
var _resolve_local_path = require("./resolve_local_path");
var _validators = require("./validators");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchArtifactVersions = async ({
  artifactRepositoryUrl
}) => {
  (0, _validators.validateUrl)(artifactRepositoryUrl);
  const parsedUrl = new _url.URL(artifactRepositoryUrl);
  let xml;
  if (parsedUrl.protocol === 'file:') {
    const file = await fetchLocalFile(parsedUrl);
    xml = file.toString();
  } else {
    const res = await (0, _nodeFetch.default)(`${artifactRepositoryUrl}?max-keys=1000`);
    xml = await res.text();
    (0, _validators.validateMimeType)(res.headers.get('content-type'), 'application/xml');
  }
  return new Promise((resolve, reject) => {
    (0, _xml2js.parseString)(xml, (err, result) => {
      var _result$ListBucketRes, _result$ListBucketRes2;
      if (err) {
        return reject(err);
      }

      // 6 artifacts per minor stack version means we have a few decades before facing this problem
      if ((_result$ListBucketRes = result.ListBucketResult.IsTruncated) !== null && _result$ListBucketRes !== void 0 && _result$ListBucketRes.includes('true')) {
        return reject(new Error('bucket content is truncated, cannot retrieve all versions'));
      }
      const record = Object.values(_productDocCommon.DocumentationProduct).reduce((res, product) => ({
        ...res,
        [product]: []
      }), {});
      (_result$ListBucketRes2 = result.ListBucketResult.Contents) === null || _result$ListBucketRes2 === void 0 ? void 0 : _result$ListBucketRes2.forEach(contentEntry => {
        const artifactName = contentEntry.Key[0];
        const parsed = (0, _productDocCommon.parseArtifactName)(artifactName);
        if (parsed) {
          var _record$productName;
          const {
            productName,
            productVersion
          } = parsed;
          (_record$productName = record[productName]) === null || _record$productName === void 0 ? void 0 : _record$productName.push(productVersion);
        }
      });
      resolve(record);
    });
  });
};
exports.fetchArtifactVersions = fetchArtifactVersions;
function fetchLocalFile(parsedUrl) {
  return new Promise((resolve, reject) => {
    const normalizedPath = (0, _resolve_local_path.resolveLocalPath)(parsedUrl);
    const xmlFilePath = Path.join(normalizedPath, 'index.xml');
    fs.readFile(xmlFilePath, (err, data) => {
      if (err) {
        reject(err);
      } else {
        resolve(data);
      }
    });
  });
}