"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.download = void 0;
var _fs = require("@kbn/fs");
var _promises = require("stream/promises");
var _nodeFetch = _interopRequireDefault(require("node-fetch"));
var _validators = require("./validators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const download = async (fileUrl, filePathAtVolume, expectedMimeType, abortController) => {
  const writeStream = (0, _fs.createWriteStream)(filePathAtVolume);
  let res;
  try {
    res = await (0, _nodeFetch.default)(fileUrl, {
      signal: abortController === null || abortController === void 0 ? void 0 : abortController.signal
    });
  } catch (err) {
    if (err.name === 'AbortError') {
      writeStream.destroy();
      throw new Error('Download aborted');
    }
    throw err;
  }
  if (!res.ok) {
    throw new Error(`Failed to download file: ${res.status} ${res.statusText}`);
  }
  (0, _validators.validateMimeType)(res.headers.get('content-type'), expectedMimeType);
  if (!res.body) {
    throw new Error('Response body is null');
  }
  try {
    await (0, _promises.pipeline)(res.body, writeStream);
  } catch (err) {
    if (err.name === 'AbortError') {
      writeStream.destroy();
      throw new Error('Download aborted during streaming');
    }
    throw err;
  }
  const {
    fullPath: artifactFullPath
  } = (0, _fs.getSafePath)(filePathAtVolume);
  await (0, _validators.validateFileSignature)(artifactFullPath, expectedMimeType);
  return artifactFullPath;
};
exports.download = download;