"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defineRoutes = defineRoutes;
var _get_alerts_group_aggregations = require("./get_alerts_group_aggregations");
var _get_alert_by_id = require("./get_alert_by_id");
var _update_alert_by_id = require("./update_alert_by_id");
var _get_alert_index = require("./get_alert_index");
var _bulk_update_alerts = require("./bulk_update_alerts");
var _find = require("./find");
var _get_browser_fields_by_rule_type_ids = require("./get_browser_fields_by_rule_type_ids");
var _get_alert_summary = require("./get_alert_summary");
var _get_alert_fields_by_rule_type_ids = require("./get_alert_fields/get_alert_fields_by_rule_type_ids");
var _bulk_update_tags = require("./bulk_update_tags");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function defineRoutes(router) {
  (0, _get_alert_by_id.getAlertByIdRoute)(router);
  (0, _update_alert_by_id.updateAlertByIdRoute)(router);
  (0, _get_alert_index.getAlertsIndexRoute)(router);
  (0, _bulk_update_alerts.bulkUpdateAlertsRoute)(router);
  (0, _bulk_update_tags.bulkUpdateTagsRoute)(router);
  (0, _find.findAlertsByQueryRoute)(router);
  (0, _get_alerts_group_aggregations.getAlertsGroupAggregations)(router);
  (0, _get_browser_fields_by_rule_type_ids.getBrowserFieldsByFeatureId)(router);
  (0, _get_alert_fields_by_rule_type_ids.getAlertFieldsByRuleTypeIds)(router);
  (0, _get_alert_summary.getAlertSummaryRoute)(router);
}