"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertFieldsByRuleTypeIds = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../common/constants");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertFieldsByRuleTypeIds = router => {
  router.get({
    path: `${_constants.BASE_RAC_ALERTS_API_PATH}/fields`,
    validate: {
      request: {
        query: _.getAlertFieldsRequestSchemaV1
      },
      response: {
        200: {
          body: () => _.getAlertFieldsResponseSchemaV1,
          description: 'Indicates a successful call.'
        },
        400: {
          description: 'Indicates an invalid schema or parameters.'
        },
        403: {
          description: 'Indicates that this call is forbidden.'
        },
        404: {
          description: 'Indicates given rule type id or ids do not exist.'
        }
      }
    },
    security: {
      authz: {
        requiredPrivileges: ['rac']
      }
    },
    options: {
      access: 'internal'
    }
  }, async (context, request, response) => {
    try {
      const {
        rule_type_ids: ruleTypeIds
      } = request.query;
      const ruleTypeIdsArray = ruleTypeIds ? Array.isArray(ruleTypeIds) ? ruleTypeIds : [ruleTypeIds] : [];
      const racContext = await context.rac;
      const alerting = await racContext.getAlertsClient();
      const alertFields = await alerting.getAlertFields(ruleTypeIdsArray);
      return response.ok({
        body: alertFields
      });
    } catch (error) {
      const formatedError = (0, _securitysolutionEsUtils.transformError)(error);
      const contentType = {
        'content-type': 'application/json'
      };
      const defaultedHeaders = {
        ...contentType
      };
      return response.customError({
        headers: defaultedHeaders,
        statusCode: formatedError.statusCode,
        body: {
          message: formatedError.message,
          attributes: {
            success: false
          }
        }
      });
    }
  });
};
exports.getAlertFieldsByRuleTypeIds = getAlertFieldsByRuleTypeIds;