"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractAuthzDescription = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const extractAuthzDescription = routeSecurity => {
  if (!routeSecurity) {
    return '';
  }
  if (!('authz' in routeSecurity) || routeSecurity.authz.enabled === false) {
    return '';
  }
  const privileges = routeSecurity.authz.requiredPrivileges;
  const groupedPrivileges = privileges.reduce((groups, privilege) => {
    var _privilege$allRequire, _privilege$anyRequire;
    if (typeof privilege === 'string') {
      groups.allRequired.push(privilege);
      return groups;
    }
    groups.allRequired.push(...((_privilege$allRequire = privilege.allRequired) !== null && _privilege$allRequire !== void 0 ? _privilege$allRequire : []));
    groups.anyRequired.push(...((_privilege$anyRequire = privilege.anyRequired) !== null && _privilege$anyRequire !== void 0 ? _privilege$anyRequire : []));
    return groups;
  }, {
    anyRequired: [],
    allRequired: []
  });
  const getPrivilegesDescription = (allRequired, anyRequired) => {
    const allPrivileges = allRequired.map(privilege => {
      var _privilege$anyOf;
      return typeof privilege === 'string' ? privilege : `(${(_privilege$anyOf = privilege.anyOf) === null || _privilege$anyOf === void 0 ? void 0 : _privilege$anyOf.join(' OR ')})`;
    }).join(' AND ');
    const anyPrivileges = anyRequired.map(privilege => {
      var _privilege$allOf;
      return typeof privilege === 'string' ? privilege : `(${(_privilege$allOf = privilege.allOf) === null || _privilege$allOf === void 0 ? void 0 : _privilege$allOf.join(' AND ')})`;
    }).join(' OR ');
    const allDescription = allRequired.length ? allPrivileges : '';
    const anyDescription = anyRequired.length ? anyPrivileges : '';
    if (allDescription && anyDescription) {
      return `(${allDescription}) AND (${anyDescription})`;
    }
    return `${allDescription}${anyDescription}`;
  };
  const getDescriptionForRoute = () => {
    const allRequired = [...groupedPrivileges.allRequired];
    const anyRequired = [...groupedPrivileges.anyRequired];
    return `Route required privileges: ${getPrivilegesDescription(allRequired, anyRequired)}.`;
  };
  return `[Required authorization] ${getDescriptionForRoute()}`;
};
exports.extractAuthzDescription = extractAuthzDescription;