"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFatalErrors = getFatalErrors;
exports.getNotifications = getNotifications;
exports.getUiStatsReporter = void 0;
exports.setFatalErrors = setFatalErrors;
exports.setNotifications = setNotifications;
exports.setUiStatsReporter = void 0;
exports.trackUiMetric = trackUiMetric;
var _common = require("@kbn/kibana-utils-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let notifications = null;
let fatalErrors = null;
function getNotifications() {
  if (!notifications) {
    throw new Error('Rollup notifications is not defined');
  }
  return notifications;
}
function setNotifications(newNotifications) {
  notifications = newNotifications;
}
function getFatalErrors() {
  if (!fatalErrors) {
    throw new Error('Rollup fatalErrors is not defined');
  }
  return fatalErrors;
}
function setFatalErrors(newFatalErrors) {
  fatalErrors = newFatalErrors;
}
const [getUiStatsReporter, setUiStatsReporter] = (0, _common.createGetterSetter)('uiMetric');

// default value if usageCollection is not available
exports.setUiStatsReporter = setUiStatsReporter;
exports.getUiStatsReporter = getUiStatsReporter;
setUiStatsReporter(() => {});
function trackUiMetric(type, eventNames, count) {
  getUiStatsReporter()(type, eventNames, count);
}