"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createJob = createJob;
var _action_types = require("../action_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  isSaving: false,
  error: undefined
};
function createJob(state = initialState, action) {
  const {
    type,
    payload
  } = action;
  switch (type) {
    case _action_types.CREATE_JOB_START:
      return {
        isSaving: true,
        error: undefined
      };
    case _action_types.CREATE_JOB_SUCCESS:
      return {
        ...state,
        isSaving: false
      };
    case _action_types.CREATE_JOB_FAILURE:
      return {
        ...state,
        error: payload.error,
        isSaving: false
      };
    case _action_types.CLEAR_CREATE_JOB_ERRORS:
      return {
        ...state,
        error: undefined
      };
    default:
      return state;
  }
}