"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobCreateUi = exports.JobCreate = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _components = require("../components");
var _eui = require("@elastic/eui");
var _services = require("../../services");
var _navigation = require("./navigation");
var _steps = require("./steps");
var _steps_config = require("./steps_config");
var _kibana_services = require("../../../kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/rollup/public/crud_app/sections/job_create/job_create.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const stepIdToTitleMap = {
  [_steps_config.STEP_LOGISTICS]: _i18n.i18n.translate('xpack.rollupJobs.create.steps.stepLogisticsTitle', {
    defaultMessage: 'Logistics'
  }),
  [_steps_config.STEP_DATE_HISTOGRAM]: _i18n.i18n.translate('xpack.rollupJobs.create.steps.stepDateHistogramTitle', {
    defaultMessage: 'Date histogram'
  }),
  [_steps_config.STEP_TERMS]: _i18n.i18n.translate('xpack.rollupJobs.create.steps.stepTermsTitle', {
    defaultMessage: 'Terms'
  }),
  [_steps_config.STEP_HISTOGRAM]: _i18n.i18n.translate('xpack.rollupJobs.create.steps.stepHistogramTitle', {
    defaultMessage: 'Histogram'
  }),
  [_steps_config.STEP_METRICS]: _i18n.i18n.translate('xpack.rollupJobs.create.steps.stepMetricsTitle', {
    defaultMessage: 'Metrics'
  }),
  [_steps_config.STEP_REVIEW]: _i18n.i18n.translate('xpack.rollupJobs.create.steps.stepReviewTitle', {
    defaultMessage: 'Review and save'
  })
};
class JobCreateUi extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "requestIndexPatternValidation", (0, _lodash.debounce)((resetDefaults = true) => {
      const indexPattern = this.getIndexPattern();
      const lastIndexPatternValidationIdx = ++this.lastIndexPatternValidationIdx;
      (0, _services.validateIndexPattern)(indexPattern).then(response => {
        // We don't need to do anything if this component has been unmounted.
        if (!this._isMounted) {
          return;
        }

        // Only re-request if the index pattern changed.
        if (lastIndexPatternValidationIdx !== this.lastIndexPatternValidationIdx) {
          return;
        }
        const {
          doesMatchIndices: doesIndexPatternMatchIndices,
          doesMatchRollupIndices: doesIndexPatternMatchRollupIndices,
          dateFields: indexPatternDateFields,
          numericFields,
          keywordFields
        } = response;
        let indexPatternAsyncErrors;
        if (doesIndexPatternMatchRollupIndices) {
          indexPatternAsyncErrors = [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.rollupJobs.create.errors.indexPatternMatchesRollupIndices",
            defaultMessage: "Index pattern must not match rollup indices.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 188,
              columnNumber: 13
            }
          })];
        } else if (!doesIndexPatternMatchIndices) {
          indexPatternAsyncErrors = [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.rollupJobs.create.errors.indexPatternNoMatchingIndices",
            defaultMessage: "Index pattern doesn't match any indices.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 195,
              columnNumber: 13
            }
          })];
        } else if (!indexPatternDateFields.length) {
          indexPatternAsyncErrors = [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.rollupJobs.create.errors.indexPatternNoTimeFields",
            defaultMessage: "Index pattern must match indices that contain time fields.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 202,
              columnNumber: 13
            }
          })];
        }
        const numericType = _i18n.i18n.translate('xpack.rollupJobs.create.numericTypeField', {
          defaultMessage: 'numeric'
        });
        const keywordType = _i18n.i18n.translate('xpack.rollupJobs.create.keywordTypeField', {
          defaultMessage: 'keyword'
        });
        const dateType = _i18n.i18n.translate('xpack.rollupJobs.create.dateTypeField', {
          defaultMessage: 'date'
        });
        const formattedNumericFields = (0, _services.formatFields)(numericFields, numericType);
        const formattedKeywordFields = (0, _services.formatFields)(keywordFields, keywordType);
        const formattedDateFields = (0, _services.formatFields)(indexPatternDateFields, dateType);
        const {
          jobToClone,
          stepsFields
        } = this.state;
        const {
          [_steps_config.STEP_METRICS]: {
            metrics
          }
        } = stepsFields;

        // Only re-type metrics if they haven't been typed already
        if (jobToClone && metrics && metrics.length && !(0, _lodash.first)(metrics).type) {
          // Re-type any pre-existing metrics entries for the job we are cloning.
          const typeMaps = [{
            fields: formattedNumericFields,
            type: numericType
          }, {
            fields: formattedKeywordFields,
            type: keywordType
          }, {
            fields: formattedDateFields,
            type: dateType
          }];
          const retypedMetrics = (0, _services.retypeMetrics)({
            metrics,
            typeMaps
          });
          this.onFieldsChange({
            metrics: retypedMetrics
          }, _steps_config.STEP_METRICS);
        }
        function sortFields(a, b) {
          const nameA = a.name.toUpperCase();
          const nameB = b.name.toUpperCase();
          if (nameA < nameB) {
            return -1;
          }
          if (nameA > nameB) {
            return 1;
          }
          return 0;
        }
        const indexPatternTermsFields = [...formattedNumericFields, ...formattedKeywordFields].sort(sortFields);
        const indexPatternHistogramFields = [...formattedNumericFields].sort(sortFields);
        const indexPatternMetricsFields = [...formattedNumericFields, ...formattedDateFields].sort(sortFields);
        indexPatternDateFields.sort();
        if (resetDefaults) {
          // Whenever the index pattern changes we default to the first date field if there is one.
          this.onFieldsChange({
            dateHistogramField: indexPatternDateFields.length ? indexPatternDateFields[0] : undefined
          }, _steps_config.STEP_DATE_HISTOGRAM);
        }
        this.setState({
          indexPatternAsyncErrors,
          indexPatternDateFields,
          indexPatternTermsFields,
          indexPatternHistogramFields,
          indexPatternMetricsFields,
          isValidatingIndexPattern: false
        });
      }).catch(error => {
        // We don't need to do anything if this component has been unmounted.
        if (!this._isMounted) {
          return;
        }

        // Ignore all responses except that to the most recent request.
        if (lastIndexPatternValidationIdx !== this.lastIndexPatternValidationIdx) {
          return;
        }

        // Expect an error in the shape provided by http service.
        if (error && error.body) {
          const {
            error: errorString,
            statusCode
          } = error.body;
          const indexPatternAsyncErrors = [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.rollupJobs.create.errors.indexPatternValidationError",
            defaultMessage: "There was a problem validating this index pattern: {statusCode} {error}",
            values: {
              error: errorString,
              statusCode
            },
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 304,
              columnNumber: 13
            }
          })];
          this.setState({
            indexPatternAsyncErrors,
            indexPatternDateFields: [],
            indexPatternTermsFields: [],
            indexPatternHistogramFields: [],
            indexPatternMetricsFields: [],
            isValidatingIndexPattern: false
          });
          return;
        }

        // This error isn't an HTTP error, so let the fatal error screen tell the user something
        // unexpected happened.
        (0, _kibana_services.getFatalErrors)().add(error, _i18n.i18n.translate('xpack.rollupJobs.create.errors.indexPatternValidationFatalErrorTitle', {
          defaultMessage: 'Rollup Job Wizard index pattern validation'
        }));
      });
    }, 300));
    (0, _defineProperty2.default)(this, "goToNextStep", () => {
      this.goToStep(this.state.nextStepId);
    });
    (0, _defineProperty2.default)(this, "goToPreviousStep", () => {
      this.goToStep(this.state.previousStepId);
    });
    (0, _defineProperty2.default)(this, "onFieldsChange", (fields, currentStepId = this.state.currentStepId) => {
      const {
        stepsFields
      } = this.state;
      const prevFields = stepsFields[currentStepId];
      const affectedStepsFields = (0, _steps_config.getAffectedStepsFields)(fields, stepsFields);
      const newFields = {
        ...prevFields,
        ...fields
      };
      const newStepsFields = {
        ...affectedStepsFields,
        [currentStepId]: newFields
      };
      this.setState({
        stepsFields: newStepsFields,
        stepsFieldErrors: this.getStepsFieldsErrors(newStepsFields)
      });
    });
    (0, _defineProperty2.default)(this, "save", () => {
      const {
        createJob
      } = this.props;
      const jobConfig = this.getAllFields();
      createJob(jobConfig);
    });
    (0, _defineProperty2.default)(this, "onToggleStartAfterCreate", eve => {
      this.setState({
        startJobAfterCreation: eve.target.checked
      });
    });
    props.kibana.services.setBreadcrumbs([_services.listBreadcrumb, _services.createBreadcrumb]);
    const {
      jobToClone: stepDefaultOverrides
    } = props;
    const _stepsFields = (0, _lodash.mapValues)(_steps_config.stepIdToStepConfigMap, step => (0, _lodash.cloneDeep)(step.getDefaultFields(stepDefaultOverrides)));
    this.state = {
      jobToClone: stepDefaultOverrides || null,
      checkpointStepId: _steps_config.stepIds[0],
      currentStepId: _steps_config.stepIds[0],
      nextStepId: _steps_config.stepIds[1],
      previousStepId: undefined,
      stepsFieldErrors: this.getStepsFieldsErrors(_stepsFields),
      // Show step errors immediately if we are cloning a job.
      areStepErrorsVisible: !!stepDefaultOverrides,
      stepsFields: _stepsFields,
      isValidatingIndexPattern: false,
      indexPatternAsyncErrors: undefined,
      indexPatternDateFields: [],
      indexPatternTermsFields: [],
      indexPatternHistogramFields: [],
      indexPatternMetricsFields: [],
      startJobAfterCreation: false
    };
    this.lastIndexPatternValidationIdx = 0;
  }
  componentDidMount() {
    this._isMounted = true;
    const {
      clearCloneJob,
      jobToClone
    } = this.props;
    if (jobToClone) {
      clearCloneJob();
      this.requestIndexPatternValidation(false);
    }
  }
  componentDidUpdate(prevProps, prevState) {
    const indexPattern = this.getIndexPattern();
    if (indexPattern !== this.getIndexPattern(prevState)) {
      // If the user hasn't entered anything, then skip validation.
      if (!indexPattern || !indexPattern.trim()) {
        this.setState({
          indexPatternAsyncErrors: undefined,
          indexPatternDateFields: [],
          isValidatingIndexPattern: false
        });
        return;
      }

      // Set the state outside of `requestIndexPatternValidation`, because that function is
      // debounced.
      this.setState({
        isValidatingIndexPattern: true
      });
      this.requestIndexPatternValidation();
    }
  }
  componentWillUnmount() {
    this._isMounted = false;
    // Clean up after ourselves.
    this.props.clearCreateJobErrors();
  }
  getSteps() {
    const {
      currentStepId,
      checkpointStepId
    } = this.state;
    const indexOfCurrentStep = _steps_config.stepIds.indexOf(currentStepId);
    const getStepStatus = (index, indexOfCurrentStep) => {
      if (index === indexOfCurrentStep) {
        return 'selected';
      } else if (index < indexOfCurrentStep) {
        return 'complete';
      } else {
        return 'incomplete';
      }
    };
    return _steps_config.stepIds.map((stepId, index) => ({
      title: stepIdToTitleMap[stepId],
      status: getStepStatus(index, indexOfCurrentStep),
      onClick: () => this.goToStep(stepId),
      disabled: !this.canGoToStep(stepId) || _steps_config.stepIds.indexOf(stepId) > _steps_config.stepIds.indexOf(checkpointStepId),
      'data-test-subj': index === indexOfCurrentStep ? `createRollupStep${index + 1}--active` : `createRollupStep${index + 1}`
    }));
  }
  goToStep(stepId) {
    // Instead of disabling the Next button while the step is invalid, we
    // instead allow the user to click the Next button, prevent them leaving
    // this step, and render a global error message to clearly convey the
    // error.
    if (!this.canGoToStep(stepId)) {
      this.setState({
        areStepErrorsVisible: true
      });
      return;
    }
    const currentStepIndex = _steps_config.stepIds.indexOf(stepId);
    this.setState({
      currentStepId: stepId,
      nextStepId: _steps_config.stepIds[currentStepIndex + 1],
      previousStepId: _steps_config.stepIds[currentStepIndex - 1],
      areStepErrorsVisible: false,
      isSaving: false
    });
    if (_steps_config.stepIds.indexOf(stepId) > _steps_config.stepIds.indexOf(this.state.checkpointStepId)) {
      this.setState({
        checkpointStepId: stepId
      });
    }
  }
  canGoToStep(stepId) {
    const indexOfStep = _steps_config.stepIds.indexOf(stepId);

    // Check every step before this one and see if it's been completed.
    const prerequisiteSteps = _steps_config.stepIds.slice(0, indexOfStep);
    return prerequisiteSteps.every(prerequisiteStepId => !this.hasStepErrors(prerequisiteStepId));
  }
  hasStepErrors(stepId) {
    const {
      indexPatternAsyncErrors,
      stepsFieldErrors
    } = this.state;
    if (stepId === _steps_config.STEP_LOGISTICS) {
      if (Boolean(indexPatternAsyncErrors)) {
        return true;
      }
    }
    const stepFieldErrors = stepsFieldErrors[stepId];
    return Object.values(stepFieldErrors).some(error => error != null);
  }
  getStepsFieldsErrors(newStepsFields) {
    return Object.keys(newStepsFields).reduce((stepsFieldErrors, stepId) => {
      const stepFields = newStepsFields[stepId];
      const fieldsValidator = _steps_config.stepIdToStepConfigMap[stepId].fieldsValidator;
      stepsFieldErrors[stepId] = typeof fieldsValidator === `function` ? fieldsValidator(stepFields) : {};
      return stepsFieldErrors;
    }, {});
  }
  getAllFields() {
    const {
      stepsFields: {
        [_steps_config.STEP_LOGISTICS]: {
          id,
          indexPattern,
          rollupIndex,
          rollupCron,
          rollupDelay,
          rollupPageSize
        },
        [_steps_config.STEP_DATE_HISTOGRAM]: {
          dateHistogramInterval,
          dateHistogramTimeZone,
          dateHistogramField
        },
        [_steps_config.STEP_TERMS]: {
          terms
        },
        [_steps_config.STEP_HISTOGRAM]: {
          histogram,
          histogramInterval
        },
        [_steps_config.STEP_METRICS]: {
          metrics
        },
        [_steps_config.STEP_REVIEW]: {}
      },
      startJobAfterCreation
    } = this.state;
    return {
      id,
      indexPattern,
      rollupIndex,
      rollupCron,
      rollupPageSize,
      rollupDelay,
      dateHistogramInterval,
      dateHistogramTimeZone,
      dateHistogramField,
      terms,
      histogram,
      histogramInterval,
      metrics,
      startJobAfterCreation
    };
  }
  getIndexPattern(state = this.state) {
    return state.stepsFields[_steps_config.STEP_LOGISTICS].indexPattern;
  }
  render() {
    const {
      isSaving,
      saveError
    } = this.props;
    let savingFeedback;
    if (isSaving) {
      savingFeedback = /*#__PURE__*/_react.default.createElement(_eui.EuiOverlayMask, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 506,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
        logo: "logoKibana",
        size: "xl",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 507,
          columnNumber: 11
        }
      }));
    }
    let saveErrorFeedback;
    if (saveError) {
      const {
        message,
        cause
      } = saveError;
      let errorBody;
      if (cause) {
        if (cause.length === 1) {
          errorBody = /*#__PURE__*/_react.default.createElement("p", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 521,
              columnNumber: 23
            }
          }, cause[0]);
        } else {
          errorBody = /*#__PURE__*/_react.default.createElement("ul", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 524,
              columnNumber: 13
            }
          }, cause.map(causeValue => /*#__PURE__*/_react.default.createElement("li", {
            key: causeValue,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 526,
              columnNumber: 17
            }
          }, causeValue)));
        }
      }
      saveErrorFeedback = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 535,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: message,
        icon: "cross",
        color: "danger",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 537,
          columnNumber: 11
        }
      }, errorBody), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 541,
          columnNumber: 11
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
      restrictWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 547,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
      bottomBorder: true,
      pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.createTitle",
        defaultMessage: "Create rollup job",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 551,
          columnNumber: 13
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 548,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 558,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_components.DeprecationCallout, {
      linksTestSubjPrefix: "createForm",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 560,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 562,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
      steps: this.getSteps(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 564,
        columnNumber: 9
      }
    }), saveErrorFeedback, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 568,
        columnNumber: 9
      }
    }), this.renderCurrentStep(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 572,
        columnNumber: 9
      }
    }), this.renderNavigation(), savingFeedback);
  }
  renderCurrentStep() {
    const {
      currentStepId,
      stepsFields,
      stepsFieldErrors,
      areStepErrorsVisible,
      isValidatingIndexPattern,
      indexPatternDateFields,
      indexPatternAsyncErrors,
      indexPatternTermsFields,
      indexPatternHistogramFields,
      indexPatternMetricsFields
    } = this.state;
    const currentStepFields = stepsFields[currentStepId];
    const currentStepFieldErrors = stepsFieldErrors[currentStepId];
    switch (currentStepId) {
      case _steps_config.STEP_LOGISTICS:
        return /*#__PURE__*/_react.default.createElement(_steps.StepLogistics, {
          fields: currentStepFields,
          onFieldsChange: this.onFieldsChange,
          fieldErrors: currentStepFieldErrors,
          hasErrors: (0, _steps_config.hasErrors)(currentStepFieldErrors),
          areStepErrorsVisible: areStepErrorsVisible,
          isValidatingIndexPattern: isValidatingIndexPattern,
          indexPatternAsyncErrors: indexPatternAsyncErrors,
          hasMatchingIndices: Boolean(indexPatternDateFields.length),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 601,
            columnNumber: 11
          }
        });
      case _steps_config.STEP_DATE_HISTOGRAM:
        return /*#__PURE__*/_react.default.createElement(_steps.StepDateHistogram, {
          indexPattern: this.getIndexPattern(),
          fields: currentStepFields,
          onFieldsChange: this.onFieldsChange,
          fieldErrors: currentStepFieldErrors,
          hasErrors: (0, _steps_config.hasErrors)(currentStepFieldErrors),
          areStepErrorsVisible: areStepErrorsVisible,
          dateFields: indexPatternDateFields,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 615,
            columnNumber: 11
          }
        });
      case _steps_config.STEP_TERMS:
        return /*#__PURE__*/_react.default.createElement(_steps.StepTerms, {
          fields: currentStepFields,
          onFieldsChange: this.onFieldsChange,
          termsFields: indexPatternTermsFields,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 628,
            columnNumber: 11
          }
        });
      case _steps_config.STEP_HISTOGRAM:
        return /*#__PURE__*/_react.default.createElement(_steps.StepHistogram, {
          fields: currentStepFields,
          onFieldsChange: this.onFieldsChange,
          fieldErrors: currentStepFieldErrors,
          hasErrors: (0, _steps_config.hasErrors)(currentStepFieldErrors),
          areStepErrorsVisible: areStepErrorsVisible,
          histogramFields: indexPatternHistogramFields,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 637,
            columnNumber: 11
          }
        });
      case _steps_config.STEP_METRICS:
        return /*#__PURE__*/_react.default.createElement(_steps.StepMetrics, {
          fields: currentStepFields,
          onFieldsChange: this.onFieldsChange,
          fieldErrors: currentStepFieldErrors,
          areStepErrorsVisible: areStepErrorsVisible,
          metricsFields: indexPatternMetricsFields,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 649,
            columnNumber: 11
          }
        });
      case _steps_config.STEP_REVIEW:
        return /*#__PURE__*/_react.default.createElement(_steps.StepReview, {
          job: this.getAllFields(),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 659,
            columnNumber: 16
          }
        });
      default:
        return null;
    }
  }
  renderNavigation() {
    const {
      isValidatingIndexPattern,
      nextStepId,
      previousStepId,
      areStepErrorsVisible,
      startJobAfterCreation
    } = this.state;
    const {
      isSaving
    } = this.props;
    const hasNextStep = nextStepId != null;

    // Users can click the next step button as long as validation hasn't executed, and as long
    // as we're not waiting on async validation to complete.
    const canGoToNextStep = !isValidatingIndexPattern && hasNextStep && (!areStepErrorsVisible || this.canGoToStep(nextStepId));
    return /*#__PURE__*/_react.default.createElement(_navigation.Navigation, {
      isSaving: isSaving,
      hasNextStep: hasNextStep,
      hasPreviousStep: previousStepId != null,
      goToNextStep: this.goToNextStep,
      goToPreviousStep: this.goToPreviousStep,
      canGoToNextStep: canGoToNextStep,
      save: this.save,
      onClickToggleStart: this.onToggleStartAfterCreate,
      startJobAfterCreation: startJobAfterCreation,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 690,
        columnNumber: 7
      }
    });
  }
}
exports.JobCreateUi = JobCreateUi;
(0, _defineProperty2.default)(JobCreateUi, "propTypes", {
  createJob: _propTypes.default.func,
  clearCloneJob: _propTypes.default.func,
  isSaving: _propTypes.default.bool,
  createJobError: _propTypes.default.node,
  jobToClone: _propTypes.default.object
});
const JobCreate = exports.JobCreate = (0, _public.withKibana)(JobCreateUi);