"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.customThresholdParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _alertingComparators = require("@kbn/alerting-comparators");
var _common = require("../common");
var _utils = require("../common/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const allowedAggregators = ['avg', 'sum', 'min', 'max', 'cardinality', 'median', 'rate', 'p95', 'p99', 'last_value'];
const comparators = Object.values({
  ..._alertingComparators.COMPARATORS,
  ..._utils.LEGACY_COMPARATORS
});
const searchConfigSchema = _configSchema.schema.object({
  index: _configSchema.schema.oneOf([_configSchema.schema.string(), _common.dataViewSpecSchema]),
  query: _configSchema.schema.object({
    language: _configSchema.schema.string(),
    query: _configSchema.schema.string({
      validate: _utils.validateKQLStringFilter
    })
  }),
  filter: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.object({
    query: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())),
    meta: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any())
  })))
});
const customCriterion = _configSchema.schema.object({
  threshold: _configSchema.schema.arrayOf(_configSchema.schema.number()),
  comparator: (0, _utils.oneOfLiterals)(comparators),
  timeUnit: _configSchema.schema.string(),
  timeSize: _configSchema.schema.number(),
  aggType: _configSchema.schema.maybe(_configSchema.schema.literal('custom')),
  metric: _configSchema.schema.never(),
  metrics: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.object({
    name: _configSchema.schema.string(),
    aggType: (0, _utils.oneOfLiterals)(allowedAggregators),
    field: _configSchema.schema.string(),
    filter: _configSchema.schema.never()
  }), _configSchema.schema.object({
    name: _configSchema.schema.string(),
    aggType: _configSchema.schema.literal('count'),
    filter: _configSchema.schema.maybe(_configSchema.schema.string({
      validate: _utils.validateKQLStringFilter
    })),
    field: _configSchema.schema.never()
  })])),
  equation: _configSchema.schema.maybe(_configSchema.schema.string()),
  label: _configSchema.schema.maybe(_configSchema.schema.string())
});
const customThresholdParamsSchema = exports.customThresholdParamsSchema = _configSchema.schema.object({
  criteria: _configSchema.schema.arrayOf(customCriterion),
  groupBy: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())])),
  alertOnNoData: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  alertOnGroupDisappear: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  searchConfiguration: searchConfigSchema
}, {
  unknowns: 'allow'
});