"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.anomalyParamsSchema = exports.AnomalyDetectorType = void 0;
var _configSchema = require("@kbn/config-schema");
var _anomaly_severity = require("@kbn/ml-anomaly-utils/anomaly_severity");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
let AnomalyDetectorType = exports.AnomalyDetectorType = /*#__PURE__*/function (AnomalyDetectorType) {
  AnomalyDetectorType["txLatency"] = "txLatency";
  AnomalyDetectorType["txThroughput"] = "txThroughput";
  AnomalyDetectorType["txFailureRate"] = "txFailureRate";
  return AnomalyDetectorType;
}({});
const detectorsSchema = _configSchema.schema.oneOf([_configSchema.schema.literal(AnomalyDetectorType.txLatency), _configSchema.schema.literal(AnomalyDetectorType.txThroughput), _configSchema.schema.literal(AnomalyDetectorType.txFailureRate)]);
const anomalyParamsSchema = exports.anomalyParamsSchema = _configSchema.schema.object({
  serviceName: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'The service name from APM.'
    }
  })),
  transactionType: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'The transaction type from APM.'
    }
  })),
  windowSize: _configSchema.schema.number({
    meta: {
      description: 'The size of the time window (in `windowUnit` units), which determines how far back to search for documents. Generally it should be a value higher than the rule check interval to avoid gaps in detection.'
    }
  }),
  windowUnit: _configSchema.schema.string({
    meta: {
      description: 'The type of units for the time window: minutes, hours, or days.'
    }
  }),
  environment: _configSchema.schema.string({
    meta: {
      description: 'The environment from APM.'
    }
  }),
  anomalySeverityType: _configSchema.schema.oneOf([_configSchema.schema.literal(_anomaly_severity.ML_ANOMALY_SEVERITY.CRITICAL), _configSchema.schema.literal(_anomaly_severity.ML_ANOMALY_SEVERITY.MAJOR), _configSchema.schema.literal(_anomaly_severity.ML_ANOMALY_SEVERITY.MINOR), _configSchema.schema.literal(_anomaly_severity.ML_ANOMALY_SEVERITY.WARNING)], {
    meta: {
      description: 'The severity of anomalies that result in an alert: critical, major, minor, or warning.'
    }
  }),
  anomalyDetectorTypes: _configSchema.schema.maybe(_configSchema.schema.arrayOf(detectorsSchema, {
    minSize: 1,
    meta: {
      description: 'The types of anomalies that are detected. For example, detect abnormal latency, throughput, or failed transaction rates.'
    }
  }))
});