"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerInternalUpdateScheduledReportRoute = void 0;
var _reportingCommon = require("@kbn/reporting-common");
var _coreHttpRouterServerInternal = require("@kbn/core-http-router-server-internal");
var _scheduled_reports = require("../../../../services/scheduled_reports");
var _common = require("../../../common");
var _request_handler = require("../../../common/request_handler");
var _utils = require("../utils");
var _schemas = require("./schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  SCHEDULE_PREFIX
} = _reportingCommon.INTERNAL_ROUTES;
const path = `${SCHEDULE_PREFIX}/{id}`;
const registerInternalUpdateScheduledReportRoute = ({
  logger,
  router,
  reporting
}) => {
  router.put({
    path,
    security: {
      authz: {
        enabled: false,
        reason: 'This route is opted out from authorization because reporting uses its own authorization model.'
      }
    },
    validate: {
      params: _schemas.updateScheduledReportParamsSchema,
      body: _schemas.updateScheduledReportBodySchema
    },
    options: {
      access: 'internal'
    }
  }, (0, _common.authorizedUserPreRouting)(reporting, async (user, context, request, responseFactory) => {
    try {
      // ensure the async dependencies are loaded
      if (!context.reporting) {
        return (0, _request_handler.handleUnavailable)(responseFactory);
      }
      await (0, _utils.validateReportingLicense)({
        reporting,
        responseFactory
      });
      const {
        id
      } = request.params;
      const counters = (0, _common.getCounters)(request.route.method, path, reporting.getUsageCounter());
      const scheduledReportsService = await _scheduled_reports.ScheduledReportsService.build({
        logger,
        reportingCore: reporting,
        request,
        responseFactory
      });
      const results = await scheduledReportsService.update({
        user,
        id,
        updateParams: request.body
      });
      counters.usageCounter();
      return responseFactory.ok({
        body: results,
        headers: {
          'content-type': 'application/json'
        }
      });
    } catch (err) {
      if (err instanceof _coreHttpRouterServerInternal.KibanaResponse) {
        return err;
      }
      throw err;
    }
  }));
};
exports.registerInternalUpdateScheduledReportRoute = registerInternalUpdateScheduledReportRoute;