"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateScheduleReport = exports.getKey = void 0;
var _reactQuery = require("@kbn/react-query");
var _mutation_keys = require("../mutation_keys");
var _update_schedule_report = require("../apis/update_schedule_report");
var _query_keys = require("../query_keys");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getKey = exports.getKey = _mutation_keys.mutationKeys.updateScheduleReport;
const useUpdateScheduleReport = ({
  http
}) => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _reactQuery.useMutation)({
    mutationKey: getKey(),
    mutationFn: params => (0, _update_schedule_report.updateScheduleReport)({
      http,
      params
    }),
    onSuccess: () => {
      queryClient.invalidateQueries({
        queryKey: _query_keys.queryKeys.allSchedules(),
        refetchType: 'active'
      });
    }
  });
};
exports.useUpdateScheduleReport = useUpdateScheduleReport;