"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScheduledReportForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _reportingPublic = require("@kbn/reporting-public");
var _reportingCommon = require("@kbn/reporting-common");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _recurring_schedule_form_fields = require("@kbn/response-ops-recurring-schedule-form/components/recurring_schedule_form_fields");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _rrule = require("@kbn/rrule");
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _coreUiSettingsCommon = require("@kbn/core-ui-settings-common");
var _moment2 = require("@kbn/response-ops-recurring-schedule-form/converters/moment");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _use_get_user_profile_query = require("../hooks/use_get_user_profile_query");
var _responsive_form_group = require("./responsive_form_group");
var _scheduled_report_form_schema = require("../schemas/scheduled_report_form_schema");
var _use_default_timezone = require("../hooks/use_default_timezone");
var _use_get_reporting_health_query = require("../hooks/use_get_reporting_health_query");
var i18n = _interopRequireWildcard(require("../translations"));
var _constants = require("../constants");
var _start_date_validator = require("../validators/start_date_validator");
var _scheduled_report_message_variables = require("../schemas/scheduled_report_message_variables");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/reporting/public/management/components/scheduled_report_form.tsx",
  _UI_TIMEZONE_OPTIONS$;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  emptyField
} = _helpers.fieldValidators;
const FormField = (0, _hook_form_lib.getUseField)({
  component: _components.Field
});
const TIMEZONE_OPTIONS = (_UI_TIMEZONE_OPTIONS$ = _coreUiSettingsCommon.TIMEZONE_OPTIONS.map(tz => ({
  inputDisplay: tz,
  value: tz
}))) !== null && _UI_TIMEZONE_OPTIONS$ !== void 0 ? _UI_TIMEZONE_OPTIONS$ : [{
  text: 'UTC',
  value: 'UTC'
}];
const CcBccFields = ({
  readOnly
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FormField, {
  path: "emailCcRecipients",
  componentProps: {
    fullWidth: true,
    euiFieldProps: {
      compressed: true,
      fullWidth: true,
      readOnly,
      'data-test-subj': 'emailCcRecipientsCombobox'
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 101,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(FormField, {
  path: "emailBccRecipients",
  componentProps: {
    fullWidth: true,
    euiFieldProps: {
      compressed: true,
      fullWidth: true,
      readOnly,
      'data-test-subj': 'emailBccRecipientsCombobox'
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 113,
    columnNumber: 5
  }
}));
const ScheduledReportForm = ({
  onSubmitForm,
  isSubmitLoading,
  scheduledReport,
  availableReportTypes,
  onClose,
  editMode,
  readOnly
}) => {
  var _scheduledReport$emai, _scheduledReport$emai2, _availableReportTypes;
  const {
    application: {
      capabilities
    },
    http,
    actions: {
      validateEmailAddresses
    },
    userProfile: userProfileService
  } = (0, _reportingPublic.useKibana)().services;
  const {
    data: userProfile,
    isLoading: isUserProfileLoading
  } = (0, _use_get_user_profile_query.useGetUserProfileQuery)({
    userProfileService
  });
  const {
    data: reportingHealth,
    isLoading: isReportingHealthLoading,
    isError: isReportingHealthError
  } = (0, _use_get_reporting_health_query.useGetReportingHealthQuery)({
    http
  });
  const hasManageReportingPrivilege = (0, _react.useMemo)(() => {
    if (!capabilities) {
      return false;
    }
    return capabilities.manageReporting.show === true;
  }, [capabilities]);
  const reportingPageLink = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: http.basePath.prepend(_reportingCommon.REPORTING_MANAGEMENT_SCHEDULES),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 7
    }
  }, i18n.REPORTING_PAGE_LINK_TEXT), [http.basePath]);
  const {
    defaultTimezone
  } = (0, _use_default_timezone.useDefaultTimezone)();
  const hasCcBcc = Boolean((_scheduledReport$emai = scheduledReport.emailCcRecipients) === null || _scheduledReport$emai === void 0 ? void 0 : _scheduledReport$emai.length) || Boolean((_scheduledReport$emai2 = scheduledReport.emailBccRecipients) === null || _scheduledReport$emai2 === void 0 ? void 0 : _scheduledReport$emai2.length);
  const [showCcBccFields, setShowCcBccFields] = (0, _react.useState)(hasCcBcc);
  const schema = (0, _react.useMemo)(() => (0, _scheduled_report_form_schema.getScheduledReportFormSchema)(validateEmailAddresses, availableReportTypes), [availableReportTypes, validateEmailAddresses]);
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: scheduledReport,
    options: {
      stripEmptyFields: true
    },
    schema,
    onSubmit: onSubmitForm
  });
  const [{
    reportTypeId,
    startDate,
    timezone,
    sendByEmail,
    emailSubject,
    emailMessage
  }] = (0, _hook_form_lib.useFormData)({
    form,
    watch: ['reportTypeId', 'startDate', 'timezone', 'sendByEmail', 'emailSubject', 'emailMessage']
  });
  const now = (0, _react.useMemo)(() => (0, _moment.default)().set({
    second: 0,
    millisecond: 0
  }), []);
  const defaultStartDateValue = (0, _react.useMemo)(() => now.toISOString(), [now]);
  const emailSubjectFieldRef = (0, _react.useRef)(null);
  const emailMessageFieldRef = (0, _react.useRef)(null);
  const onSelectMessageVariable = (0, _react.useCallback)((field, variable) => {
    var _fieldValues$field, _fieldElement$selecti, _fieldElement$selecti2;
    const fieldRefs = {
      emailSubject: emailSubjectFieldRef,
      emailMessage: emailMessageFieldRef
    };
    const fieldValues = {
      emailSubject,
      emailMessage
    };
    const fieldElement = fieldRefs[field].current;
    if (!fieldElement) {
      return;
    }
    const templatedVariable = (0, _public.templateActionVariable)(variable);
    const currentValue = (_fieldValues$field = fieldValues[field]) !== null && _fieldValues$field !== void 0 ? _fieldValues$field : '';
    const selectionStart = (_fieldElement$selecti = fieldElement.selectionStart) !== null && _fieldElement$selecti !== void 0 ? _fieldElement$selecti : 0;
    const selectionEnd = (_fieldElement$selecti2 = fieldElement.selectionEnd) !== null && _fieldElement$selecti2 !== void 0 ? _fieldElement$selecti2 : 0;
    const textBeforeSelection = currentValue.substring(0, selectionStart);
    const textAfterSelection = currentValue.substring(selectionEnd);
    const newValue = `${textBeforeSelection}${templatedVariable}${textAfterSelection}`;
    form.setFieldValue(field, newValue);

    // Restore focus after React updates the DOM
    requestAnimationFrame(() => {
      const newCaretPosition = selectionStart + templatedVariable.length;
      fieldElement.selectionStart = newCaretPosition;
      fieldElement.selectionEnd = newCaretPosition;
      fieldElement.focus();
    });
  }, [emailMessage, emailSubject, form]);

  // Autofill the user's email if they have one and are not a reporting manager
  (0, _react.useEffect)(() => {
    if (!hasManageReportingPrivilege && !isUserProfileLoading && userProfile !== null && userProfile !== void 0 && userProfile.user.email &&
    // Even though auto-updating the recipients when editing an existing schedule would be useful
    // for non-managers that changed their profile email, it could also be disruptive
    // see https://github.com/elastic/kibana/issues/228050#issuecomment-3563309593
    !editMode && !readOnly) {
      form.setFieldValue('emailRecipients', [userProfile.user.email]);
      form.validate();
    }
  }, [form, editMode, readOnly, hasManageReportingPrivilege, isUserProfileLoading, userProfile === null || userProfile === void 0 ? void 0 : userProfile.user.email]);
  const isEmailActive = Boolean(sendByEmail);
  const onSubmit = async () => {
    try {
      if (await form.validate()) {
        await form.submit();
        onClose();
      }
    } catch (e) {
      // Keep the flyout open in case of schedule error
    }
  };
  const isLoadingDependencies = isReportingHealthLoading || isUserProfileLoading;
  const hasUnmetPrerequisites = !(reportingHealth !== null && reportingHealth !== void 0 && reportingHealth.isSufficientlySecure) || !(reportingHealth !== null && reportingHealth !== void 0 && reportingHealth.hasPermanentEncryptionKey);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 11
    }
  }, i18n.SCHEDULED_REPORT_FLYOUT_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 7
    }
  }, isLoadingDependencies ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 11
    }
  }) : isReportingHealthError ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: i18n.CANNOT_LOAD_REPORTING_HEALTH_TITLE,
    iconType: "error",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 13
    }
  }, i18n.CANNOT_LOAD_REPORTING_HEALTH_MESSAGE)) : hasUnmetPrerequisites ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: i18n.UNMET_REPORTING_PREREQUISITES_TITLE,
    iconType: "error",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 13
    }
  }, i18n.UNMET_REPORTING_PREREQUISITES_MESSAGE)) : /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form,
    id: _constants.SCHEDULED_REPORT_FORM_ID,
    "data-test-subj": "scheduleExportForm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_responsive_form_group.ResponsiveFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 314,
        columnNumber: 22
      }
    }, i18n.SCHEDULED_REPORT_FORM_DETAILS_SECTION_TITLE),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(FormField, {
    path: "title",
    componentProps: {
      fullWidth: true,
      euiFieldProps: {
        compressed: true,
        fullWidth: true,
        append: i18n.SCHEDULED_REPORT_FORM_FILE_NAME_SUFFIX,
        readOnly,
        'data-test-subj': 'reportTitleInput'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(FormField, {
    path: "reportTypeId",
    componentProps: {
      fullWidth: true,
      euiFieldProps: {
        compressed: true,
        fullWidth: true,
        options: (_availableReportTypes = availableReportTypes === null || availableReportTypes === void 0 ? void 0 : availableReportTypes.map(f => ({
          inputDisplay: f.label,
          value: f.id
        }))) !== null && _availableReportTypes !== void 0 ? _availableReportTypes : [],
        readOnly: editMode || readOnly,
        'data-test-subj': 'reportTypeIdSelect'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 329,
      columnNumber: 15
    }
  }), reportTypeId === 'printablePdfV2' && /*#__PURE__*/_react.default.createElement(FormField, {
    path: "optimizedForPrinting",
    config: {
      type: _hook_form_lib.FIELD_TYPES.TOGGLE,
      label: i18n.SCHEDULED_REPORT_FORM_OPTIMIZED_FOR_PRINTING_LABEL
    },
    componentProps: {
      helpText: i18n.SCHEDULED_REPORT_FORM_OPTIMIZED_FOR_PRINTING_DESCRIPTION,
      euiFieldProps: {
        compressed: true,
        readOnly: editMode || readOnly
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_responsive_form_group.ResponsiveFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 362,
        columnNumber: 22
      }
    }, i18n.SCHEDULED_REPORT_FORM_SCHEDULE_SECTION_TITLE),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(FormField, {
    path: "startDate",
    config: {
      type: _hook_form_lib.FIELD_TYPES.DATE_PICKER,
      label: i18n.SCHEDULED_REPORT_FORM_START_DATE_LABEL,
      defaultValue: defaultStartDateValue,
      serializer: _moment2.convertMomentToString,
      deserializer: _moment2.convertStringToMoment,
      validations: [{
        validator: emptyField(i18n.SCHEDULED_REPORT_FORM_START_DATE_REQUIRED_MESSAGE)
      }, {
        validator: (0, _start_date_validator.getStartDateValidator)(now, timezone !== null && timezone !== void 0 ? timezone : defaultTimezone, startDate)
      }]
    },
    componentProps: {
      fullWidth: true,
      euiFieldProps: {
        compressed: true,
        fullWidth: true,
        showTimeSelect: true,
        minDate: now,
        readOnly,
        'data-test-subj': 'startDatePicker'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(FormField, {
    path: "timezone",
    config: {
      type: _hook_form_lib.FIELD_TYPES.SUPER_SELECT,
      defaultValue: defaultTimezone,
      validations: [{
        validator: emptyField(i18n.SCHEDULED_REPORT_FORM_START_DATE_REQUIRED_MESSAGE)
      }]
    },
    componentProps: {
      id: 'timezone',
      fullWidth: true,
      euiFieldProps: {
        compressed: true,
        fullWidth: true,
        options: TIMEZONE_OPTIONS,
        readOnly,
        'data-test-subj': 'timezoneCombobox',
        prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
          htmlFor: "timezone",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 414,
            columnNumber: 23
          }
        }, i18n.SCHEDULED_REPORT_FORM_TIMEZONE_LABEL),
        'aria-label': `${i18n.SCHEDULED_REPORT_FORM_TIMEZONE_LABEL} ${timezone}`
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 393,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 422,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_recurring_schedule_form_fields.RecurringScheduleFormFields, {
    startDate: startDate,
    timezone: timezone ? [timezone] : [defaultTimezone],
    hideTimezone: true,
    supportsEndOptions: false,
    minFrequency: _rrule.Frequency.MONTHLY,
    showTimeInSummary: true,
    compressed: true,
    readOnly: readOnly,
    initialRecurringSchedule: scheduledReport.recurringSchedule,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 423,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_responsive_form_group.ResponsiveFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 436,
        columnNumber: 22
      }
    }, i18n.SCHEDULED_REPORT_FORM_EXPORTS_SECTION_TITLE),
    description: !editMode && /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 439,
        columnNumber: 19
      }
    }, i18n.SCHEDULED_REPORT_FORM_EXPORTS_SECTION_DESCRIPTION, " ", reportingPageLink, "."),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 435,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(FormField, {
    path: "sendByEmail",
    componentProps: {
      helpText: !hasManageReportingPrivilege && !(userProfile !== null && userProfile !== void 0 && userProfile.user.email) ? i18n.SCHEDULED_REPORT_FORM_NO_USER_EMAIL_HINT : undefined,
      euiFieldProps: {
        compressed: true,
        'data-test-subj': 'sendByEmailToggle',
        disabled: readOnly || !reportingHealth.areNotificationsEnabled || !hasManageReportingPrivilege && !(userProfile !== null && userProfile !== void 0 && userProfile.user.email)
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 445,
      columnNumber: 15
    }
  }), reportingHealth.areNotificationsEnabled ? isEmailActive && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 465,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(FormField, {
    path: "emailRecipients",
    componentProps: {
      fullWidth: true,
      helpText: hasManageReportingPrivilege ? i18n.SCHEDULED_REPORT_FORM_EMAIL_RECIPIENTS_HINT : i18n.SCHEDULED_REPORT_FORM_EMAIL_SELF_HINT,
      labelAppend: hasManageReportingPrivilege && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        "data-test-subj": "showCcBccButton",
        onClick: () => {
          setShowCcBccFields(old => !old);
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 474,
          columnNumber: 27
        }
      }, i18n.SCHEDULED_REPORT_FORM_EMAIL_SHOW_CC_BCC_LABEL),
      euiFieldProps: {
        compressed: true,
        fullWidth: true,
        isDisabled: !hasManageReportingPrivilege,
        'data-test-subj': 'emailRecipientsCombobox',
        readOnly
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 466,
      columnNumber: 21
    }
  }), hasManageReportingPrivilege && showCcBccFields && /*#__PURE__*/_react.default.createElement(CcBccFields, {
    readOnly: readOnly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 494,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(FormField, {
    path: "emailSubject",
    componentProps: {
      labelAppend: /*#__PURE__*/_react.default.createElement(_public.AddMessageVariablesOptional, {
        isOptionalField: true,
        messageVariables: _scheduled_report_message_variables.scheduledReportMessageVariables,
        onSelectEventHandler: variable => onSelectMessageVariable('emailSubject', variable),
        paramsProperty: "emailSubject",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 501,
          columnNumber: 27
        }
      }),
      euiFieldProps: {
        inputRef: emailSubjectFieldRef,
        compressed: true,
        fullWidth: true,
        disabled: readOnly,
        'data-test-subj': 'emailSubjectInput'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 497,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(FormField, {
    path: "emailMessage",
    componentProps: {
      labelAppend: /*#__PURE__*/_react.default.createElement(_public.AddMessageVariablesOptional, {
        isOptionalField: true,
        messageVariables: _scheduled_report_message_variables.scheduledReportMessageVariables,
        onSelectEventHandler: variable => onSelectMessageVariable('emailMessage', variable),
        paramsProperty: "emailMessage",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 524,
          columnNumber: 27
        }
      }),
      helpText: i18n.SCHEDULED_REPORT_FORM_EMAIL_MESSAGE_HINT,
      euiFieldProps: {
        inputRef: emailMessageFieldRef,
        compressed: true,
        fullWidth: true,
        disabled: readOnly,
        'data-test-subj': 'emailMessageTextArea',
        rows: 4
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 520,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 545,
      columnNumber: 21
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: i18n.SCHEDULED_REPORT_FORM_EMAIL_SENSITIVE_INFO_TITLE,
    iconType: "info",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 547,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 553,
      columnNumber: 23
    }
  }, i18n.SCHEDULED_REPORT_FORM_EMAIL_SENSITIVE_INFO_MESSAGE))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 559,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: i18n.SCHEDULED_REPORT_FORM_MISSING_EMAIL_CONNECTOR_TITLE,
    iconType: "info",
    size: "s",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 560,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 567,
      columnNumber: 21
    }
  }, i18n.SCHEDULED_REPORT_FORM_MISSING_EMAIL_CONNECTOR_MESSAGE)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 575,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 576,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 577,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "scheduleExportCancelButton",
    onClick: onClose,
    flush: "left",
    "aria-label": i18n.SCHEDULED_REPORT_FLYOUT_CANCEL_BUTTON_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 578,
      columnNumber: 13
    }
  }, i18n.SCHEDULED_REPORT_FLYOUT_CANCEL_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 587,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    type: "submit",
    form: _constants.SCHEDULED_REPORT_FORM_ID,
    "data-test-subj": "scheduleExportSubmitButton",
    isDisabled: isReportingHealthLoading || isUserProfileLoading || readOnly,
    onClick: onSubmit,
    isLoading: isSubmitLoading,
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 588,
      columnNumber: 13
    }
  }, i18n.SCHEDULED_REPORT_FLYOUT_SUBMIT_BUTTON_LABEL)))));
};
exports.ScheduledReportForm = ScheduledReportForm;