"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateSeeds = validateSeeds;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/remote_clusters/public/application/sections/components/remote_cluster_config_steps/remote_cluster_form/validators/validate_seeds.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function validateSeeds(seeds, seedInput) {
  const seedsHaveBeenCreated = seeds.some(seed => Boolean(seed.trim()));
  if (seedsHaveBeenCreated) {
    return null;
  }

  // If the user hasn't entered any seeds then we only want to prompt them for some if they
  // aren't already in the process of entering one in. In this case, we'll just show the
  // combobox-specific validation.
  if (seedInput) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.form.errors.seedMissing",
    defaultMessage: "At least one seed node is required.",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  });
}