"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.reindexHandler = void 0;
var _i18n = require("@kbn/i18n");
var _upgradeAssistantPkgCommon = require("@kbn/upgrade-assistant-pkg-common");
var _upgradeAssistantPkgServer = require("@kbn/upgrade-assistant-pkg-server");
var _reindex_actions = require("./reindex_actions");
var _reindex_service = require("./reindex_service");
var _error = require("./error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const reindexHandler = async ({
  credentialStore,
  dataClient,
  request,
  indexName,
  newIndexName,
  licensing,
  log,
  savedObjects,
  reindexOptions,
  security,
  version,
  rollupsEnabled
}) => {
  const callAsCurrentUser = dataClient.asCurrentUser;
  const reindexActions = (0, _reindex_actions.reindexActionsFactory)(savedObjects, callAsCurrentUser, log, _upgradeAssistantPkgServer.getRollupJobByIndexName, rollupsEnabled);
  const reindexService = (0, _reindex_service.reindexServiceFactory)(callAsCurrentUser, reindexActions, log, licensing, version);
  if (!(await reindexService.hasRequiredPrivileges([indexName, newIndexName]))) {
    throw _error.error.accessForbidden(_i18n.i18n.translate('xpack.reindexService.indexPrivilegesErrorBatch', {
      defaultMessage: 'You do not have adequate privileges to reindex "{indexName}" to "{newIndexName}".',
      values: {
        indexName,
        newIndexName
      }
    }));
  }
  const existingOp = await reindexService.findReindexOperation(indexName);

  // If the reindexOp already exists and it's paused, resume it. Otherwise create a new one.
  const reindexOp = existingOp && existingOp.attributes.status === _upgradeAssistantPkgCommon.ReindexStatus.paused ? await reindexService.resumeReindexOperation(indexName, reindexOptions) : await reindexService.createReindexOperation({
    indexName,
    newIndexName,
    opts: reindexOptions
  });

  // Add users credentials for the worker to use
  await credentialStore.set({
    reindexOp,
    request,
    security
  });
  return reindexOp.attributes;
};
exports.reindexHandler = reindexHandler;