"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHostBreakdownSizeTimeseries = getHostBreakdownSizeTimeseries;
var _server = require("@kbn/observability-plugin/server");
var _profilingUtils = require("@kbn/profiling-utils");
var _histogram = require("../../../common/histogram");
var _storage_explorer = require("../../../common/storage_explorer");
var _get_daily_data_generation = require("./get_daily_data_generation.size");
var _get_indices_stats = require("./get_indices_stats");
var _get_profiling_hosts_details_by_id = require("./get_profiling_hosts_details_by_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getHostBreakdownSizeTimeseries({
  client,
  timeFrom,
  timeTo,
  kuery,
  indexLifecyclePhase
}) {
  var _response$aggregation, _response$aggregation2;
  const bucketWidth = (0, _histogram.computeBucketWidthFromTimeRangeAndBucketCount)(timeFrom, timeTo, 50);
  const [{
    indices: allIndicesStats
  }, response] = await Promise.all([(0, _get_indices_stats.getIndicesStats)({
    client: client.getEsClient(),
    indices: _get_indices_stats.allIndices
  }), client.search('profiling_events_metrics_size', {
    index: ['profiling-events-*', 'profiling-metrics'],
    query: {
      bool: {
        filter: [...(0, _server.kqlQuery)(kuery), {
          range: {
            [_profilingUtils.ProfilingESField.Timestamp]: {
              gte: String(timeFrom),
              lt: String(timeTo),
              format: 'epoch_second'
            }
          }
        }, ...(indexLifecyclePhase !== _storage_explorer.IndexLifecyclePhaseSelectOption.All ? (0, _server.termQuery)('_tier', _storage_explorer.indexLifeCyclePhaseToDataTier[indexLifecyclePhase]) : [])]
      }
    },
    aggs: {
      hosts: {
        terms: {
          field: _profilingUtils.ProfilingESField.HostID
        },
        aggs: {
          storageTimeseries: {
            date_histogram: {
              field: _profilingUtils.ProfilingESField.Timestamp,
              fixed_interval: `${bucketWidth}s`
            },
            aggs: {
              indices: {
                terms: {
                  field: '_index',
                  size: 500
                }
              }
            }
          }
        }
      }
    }
  })]);
  const hostIds = (_response$aggregation = response.aggregations) === null || _response$aggregation === void 0 ? void 0 : _response$aggregation.hosts.buckets.map(bucket => bucket.key);
  const hostsDetailsMap = hostIds ? await (0, _get_profiling_hosts_details_by_id.getProfilingHostsDetailsById)({
    client,
    timeFrom,
    timeTo,
    kuery,
    hostIds
  }) : {};
  return ((_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : _response$aggregation2.hosts.buckets.map(bucket => {
    const hostId = bucket.key;
    const hostDetails = hostsDetailsMap[hostId];
    const timeseries = bucket.storageTimeseries.buckets.map(dateHistogramBucket => {
      const estimatedSize = allIndicesStats ? dateHistogramBucket.indices.buckets.reduce((prev, curr) => {
        return prev + (0, _get_daily_data_generation.getEstimatedSizeForDocumentsInIndex)({
          allIndicesStats,
          indexName: curr.key,
          numberOfDocs: curr.doc_count
        });
      }, 0) : 0;
      return {
        x: dateHistogramBucket.key,
        y: estimatedSize
      };
    });
    return {
      hostId,
      hostName: (hostDetails === null || hostDetails === void 0 ? void 0 : hostDetails.hostName) || '',
      timeseries
    };
  })) || [];
}