"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MissingSymbolsCallout = MissingSymbolsCallout;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _profilingUtils = require("@kbn/profiling-utils");
var _profiling_app_page_template = require("../profiling_app_page_template");
var _use_profiling_dependencies = require("../contexts/profiling_dependencies/use_profiling_dependencies");
var _use_profiling_router = require("../../hooks/use_profiling_router");
var _add_data_view = require("../../views/add_data_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/frame_information_window/missing_symbols_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function MissingSymbolsCallout({
  frameType
}) {
  const languageType = (0, _profilingUtils.getLanguageType)({
    frameType
  });
  const router = (0, _use_profiling_router.useProfilingRouter)();
  const {
    docLinks
  } = (0, _use_profiling_dependencies.useProfilingDependencies)().start.core;
  if (languageType === 'NATIVE') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      announceOnMount: true,
      title: _i18n.i18n.translate('xpack.profiling.frameInformationWindow.missingSymbols.native.title', {
        defaultMessage: 'Missing symbols'
      }),
      color: "warning",
      iconType: "question",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.profiling.frameInformationWindow.missingSymbols.native",
      defaultMessage: "To see function names and line numbers in traces of applications written in programming languages that compile to native code (C, C++, Rust, Go, etc.), you need to push symbols to the cluster using the elastic-profiling binary. {readMore}, or download the binary below.",
      values: {
        readMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "profilingMissingSymbolsCalloutReadMoreLink",
          href: `${docLinks.ELASTIC_WEBSITE_URL}/guide/en/observability/${docLinks.DOC_LINK_VERSION}/profiling-add-symbols.html`,
          target: "_blank",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 45,
            columnNumber: 17
          }
        }, _i18n.i18n.translate('xpack.profiling.frameInformationWindow.missingSymbols.native.readMore', {
          defaultMessage: 'Read more'
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "profilingMissingSymbolsCalloutUploadSymbolsButton",
      href: router.link('/add-data-instructions', {
        query: {
          selectedTab: _add_data_view.AddDataTabs.Symbols
        }
      }),
      color: "warning",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.profiling.frameInformationWindow.missingSymbols.native.downloadBinary', {
      defaultMessage: 'Upload Symbols'
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.profiling.frameInformationWindow.missingSymbols.interpreted.title', {
      defaultMessage: 'Missing symbols error'
    }),
    color: "warning",
    iconType: "question",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.profiling.frameInformationWindow.missingSymbols.interpreted', {
    defaultMessage: 'Symbols are not available because of an error in the unwinder for this language or an unknown error with the interpreter.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "profilingMissingSymbolsCalloutReportAProblemButton",
    href: _profiling_app_page_template.PROFILING_FEEDBACK_LINK,
    target: "_blank",
    color: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.profiling.frameInformationWindow.missingSymbols.interpreted.reportProblem', {
    defaultMessage: 'Report a problem'
  })));
}