"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlameGraph = FlameGraph;
var _charts = require("@elastic/charts");
var _chartsTheme = require("@kbn/charts-theme");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _get_flamegraph_model = require("../../utils/get_flamegraph_model");
var _frame_information_tooltip = require("../frame_information_window/frame_information_tooltip");
var _flamegraph_tooltip = require("./flamegraph_tooltip");
var _flame_graph_legend = require("./flame_graph_legend");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769602143372611309/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/flamegraph/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FlameGraph({
  id,
  comparisonMode,
  primaryFlamegraph,
  comparisonFlamegraph,
  baseline,
  comparison,
  searchText,
  onChangeSearchText,
  isEmbedded = false
}) {
  var _primaryFlamegraph$To;
  const [showInformationWindow, setShowInformationWindow] = (0, _react.useState)(false);
  function toggleShowInformationWindow() {
    setShowInformationWindow(prev => !prev);
  }
  const theme = (0, _eui.useEuiTheme)();
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const trackProfilingEvent = (0, _public.useUiTracker)({
    app: 'profiling'
  });
  const columnarData = (0, _react.useMemo)(() => {
    return (0, _get_flamegraph_model.getFlamegraphModel)({
      primaryFlamegraph,
      comparisonFlamegraph,
      colorSuccess: theme.euiTheme.colors.success,
      colorDanger: theme.euiTheme.colors.danger,
      colorNeutral: theme.euiTheme.colors.lightShade,
      comparisonMode,
      baseline,
      comparison
    });
  }, [primaryFlamegraph, comparisonFlamegraph, theme.euiTheme.colors.success, theme.euiTheme.colors.danger, theme.euiTheme.colors.lightShade, comparisonMode, baseline, comparison]);
  const chartTheme = {
    chartMargins: {
      top: 0,
      left: 0,
      bottom: 0,
      right: 0
    },
    chartPaddings: {
      left: 0,
      right: 0,
      top: 0,
      bottom: 0
    },
    tooltip: {
      maxWidth: 500
    }
  };
  const totalSamples = columnarData.viewModel.value[0];
  const comparisonTotalSamples = comparisonFlamegraph === null || comparisonFlamegraph === void 0 ? void 0 : comparisonFlamegraph.CountInclusive[0];
  const [highlightedVmIndex, setHighlightedVmIndex] = (0, _react.useState)(undefined);
  const selected = primaryFlamegraph && highlightedVmIndex !== undefined ? {
    fileID: primaryFlamegraph.FileID[highlightedVmIndex],
    frameType: primaryFlamegraph.FrameType[highlightedVmIndex],
    exeFileName: primaryFlamegraph.ExeFilename[highlightedVmIndex],
    addressOrLine: primaryFlamegraph.AddressOrLine[highlightedVmIndex],
    functionName: primaryFlamegraph.FunctionName[highlightedVmIndex],
    sourceFileName: primaryFlamegraph.SourceFilename[highlightedVmIndex],
    sourceLine: primaryFlamegraph.SourceLine[highlightedVmIndex],
    countInclusive: primaryFlamegraph.CountInclusive[highlightedVmIndex],
    countExclusive: primaryFlamegraph.CountExclusive[highlightedVmIndex],
    selfAnnualCO2Kgs: primaryFlamegraph.SelfAnnualCO2KgsItems[highlightedVmIndex],
    totalAnnualCO2Kgs: primaryFlamegraph.TotalAnnualCO2KgsItems[highlightedVmIndex],
    selfAnnualCostUSD: primaryFlamegraph.SelfAnnualCostsUSDItems[highlightedVmIndex],
    totalAnnualCostUSD: primaryFlamegraph.TotalAnnualCostsUSDItems[highlightedVmIndex]
  } : undefined;
  const primaryFlamegraphNodeId = highlightedVmIndex !== undefined ? primaryFlamegraph === null || primaryFlamegraph === void 0 ? void 0 : primaryFlamegraph.ID[highlightedVmIndex] : undefined;
  const comparisonFlamegraphNode = primaryFlamegraphNodeId !== undefined ? columnarData.comparisonNodesById[primaryFlamegraphNodeId] : undefined;
  const comparisonSelected = comparisonFlamegraphNode !== undefined ? {
    fileID: comparisonFlamegraphNode.FileID,
    frameType: comparisonFlamegraphNode.FrameType,
    exeFileName: comparisonFlamegraphNode.ExeFileName,
    addressOrLine: comparisonFlamegraphNode.AddressOrLine,
    functionName: comparisonFlamegraphNode.FunctionName,
    sourceFileName: comparisonFlamegraphNode.SourceFileName,
    sourceLine: comparisonFlamegraphNode.SourceLine,
    countInclusive: comparisonFlamegraphNode.CountInclusive,
    countExclusive: comparisonFlamegraphNode.CountExclusive,
    selfAnnualCO2Kgs: comparisonFlamegraphNode.SelfAnnualCO2Kgs,
    totalAnnualCO2Kgs: comparisonFlamegraphNode.TotalAnnualCO2Kgs,
    selfAnnualCostUSD: comparisonFlamegraphNode.SelfAnnualCostUSD,
    totalAnnualCostUSD: comparisonFlamegraphNode.TotalAnnualCostUSD
  } : undefined;
  (0, _react.useEffect)(() => {
    setHighlightedVmIndex(undefined);
  }, [columnarData.key]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  }, columnarData.viewModel.label.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    style: {
      minHeight: '400px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    key: columnarData.key,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: chartTheme,
    baseTheme: chartBaseTheme,
    onElementClick: elements => {
      const selectedElement = elements[0];
      if (Number.isNaN(selectedElement === null || selectedElement === void 0 ? void 0 : selectedElement.vmIndex)) {
        setHighlightedVmIndex(undefined);
      } else {
        setHighlightedVmIndex(selectedElement.vmIndex);
      }
    },
    locale: _i18n.i18n.getLocale(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    actions: [{
      label: '',
      onSelect: () => {}
    }],
    customTooltip: props => {
      if (!primaryFlamegraph) {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
      }
      const valueIndex = props.values[0].valueAccessor;
      const label = primaryFlamegraph.Label[valueIndex];
      const countInclusive = primaryFlamegraph.CountInclusive[valueIndex];
      const countExclusive = primaryFlamegraph.CountExclusive[valueIndex];
      const totalSeconds = primaryFlamegraph.TotalSeconds;
      const nodeID = primaryFlamegraph.ID[valueIndex];
      const inline = primaryFlamegraph.Inline[valueIndex];
      const comparisonNode = columnarData.comparisonNodesById[nodeID];
      const parentLabel = inline ?
      // If it's an inline frame, look up for its parent frame
      primaryFlamegraph.Label[primaryFlamegraph.Edges.findIndex(edge => edge.includes(valueIndex))] : undefined;
      return /*#__PURE__*/_react.default.createElement(_flamegraph_tooltip.FlameGraphTooltip, {
        annualCO2KgsInclusive: primaryFlamegraph.TotalAnnualCO2KgsItems[valueIndex],
        annualCostsUSDInclusive: primaryFlamegraph.TotalAnnualCostsUSDItems[valueIndex],
        baselineScaleFactor: baseline,
        comparisonAnnualCO2KgsInclusive: comparisonNode === null || comparisonNode === void 0 ? void 0 : comparisonNode.TotalAnnualCO2Kgs,
        comparisonAnnualCostsUSDInclusive: comparisonNode === null || comparisonNode === void 0 ? void 0 : comparisonNode.TotalAnnualCostUSD,
        comparisonCountExclusive: comparisonNode === null || comparisonNode === void 0 ? void 0 : comparisonNode.CountExclusive,
        comparisonCountInclusive: comparisonNode === null || comparisonNode === void 0 ? void 0 : comparisonNode.CountInclusive,
        comparisonScaleFactor: comparison,
        comparisonTotalSamples: comparisonFlamegraph === null || comparisonFlamegraph === void 0 ? void 0 : comparisonFlamegraph.CountInclusive[0],
        comparisonTotalSeconds: comparisonFlamegraph === null || comparisonFlamegraph === void 0 ? void 0 : comparisonFlamegraph.TotalSeconds,
        countExclusive: countExclusive,
        countInclusive: countInclusive,
        isRoot: valueIndex === 0,
        label: label,
        onShowMoreClick: () => {
          trackProfilingEvent({
            metric: 'flamegraph_node_details_click'
          });
          toggleShowInformationWindow();
          setHighlightedVmIndex(valueIndex);
        },
        totalSamples: totalSamples,
        totalSeconds: totalSeconds,
        inline: inline,
        parentLabel: parentLabel,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 182,
          columnNumber: 25
        }
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Flame, {
    id: id,
    columnarData: columnarData.viewModel,
    valueAccessor: d => d.value,
    valueFormatter: value => `${value}`,
    animation: {
      duration: 100
    },
    controlProviderCallback: {},
    search: searchText ? {
      text: searchText
    } : undefined,
    onSearchTextChange: onChangeSearchText,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_flame_graph_legend.FlameGraphLegend, {
    legendItems: columnarData.legendItems,
    asScale: !!comparisonFlamegraph,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 11
    }
  }))), showInformationWindow && /*#__PURE__*/_react.default.createElement(_frame_information_tooltip.FrameInformationTooltip, {
    compressed: true,
    onClose: toggleShowInformationWindow,
    comparisonFrame: comparisonSelected,
    comparisonTotalSeconds: comparisonFlamegraph === null || comparisonFlamegraph === void 0 ? void 0 : comparisonFlamegraph.TotalSeconds,
    comparisonTotalSamples: comparisonTotalSamples,
    frame: selected,
    totalSeconds: (_primaryFlamegraph$To = primaryFlamegraph === null || primaryFlamegraph === void 0 ? void 0 : primaryFlamegraph.TotalSeconds) !== null && _primaryFlamegraph$To !== void 0 ? _primaryFlamegraph$To : 0,
    totalSamples: totalSamples,
    showSymbolsStatus: !isEmbedded,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 9
    }
  }));
}