"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.securityLabsIndexPrefix = exports.securityLabsIndexPattern = exports.productDocIndexPrefix = exports.productDocIndexPattern = exports.getSecurityLabsIndexName = exports.getProductDocIndexName = void 0;
var _is_default_inference_endpoint = require("./is_default_inference_endpoint");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const productDocIndexPrefix = exports.productDocIndexPrefix = '.kibana_ai_product_doc';
const productDocIndexPattern = exports.productDocIndexPattern = `${productDocIndexPrefix}_*`;
const getProductDocIndexName = (productName, inferenceId) => {
  return `${productDocIndexPrefix}_${productName.toLowerCase()}${!(0, _is_default_inference_endpoint.isImpliedDefaultElserInferenceId)(inferenceId) ? `-${inferenceId}` : ''}`;
};

/**
 * Index name prefix for Security Labs content.
 */
exports.getProductDocIndexName = getProductDocIndexName;
const securityLabsIndexPrefix = exports.securityLabsIndexPrefix = '.kibana_ai_security_labs';

/**
 * Index pattern for Security Labs content.
 */
const securityLabsIndexPattern = exports.securityLabsIndexPattern = `${securityLabsIndexPrefix}*`;

/**
 * Returns the index name for Security Labs content.
 * Format: .kibana_ai_security_labs[-{inferenceId}]
 */
const getSecurityLabsIndexName = inferenceId => {
  return `${securityLabsIndexPrefix}${!(0, _is_default_inference_endpoint.isImpliedDefaultElserInferenceId)(inferenceId) ? `-${inferenceId}` : ''}`;
};
exports.getSecurityLabsIndexName = getSecurityLabsIndexName;