"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ENSURE_DOC_UP_TO_DATE_TASK_ID", {
  enumerable: true,
  get: function () {
    return _ensure_up_to_date.ENSURE_DOC_UP_TO_DATE_TASK_ID;
  }
});
Object.defineProperty(exports, "ENSURE_SECURITY_LABS_UP_TO_DATE_TASK_ID", {
  enumerable: true,
  get: function () {
    return _ensure_security_labs_up_to_date.ENSURE_SECURITY_LABS_UP_TO_DATE_TASK_ID;
  }
});
Object.defineProperty(exports, "INSTALL_ALL_TASK_ID", {
  enumerable: true,
  get: function () {
    return _install_all.INSTALL_ALL_TASK_ID;
  }
});
Object.defineProperty(exports, "INSTALL_ALL_TASK_ID_MULTILINGUAL", {
  enumerable: true,
  get: function () {
    return _install_all.INSTALL_ALL_TASK_ID_MULTILINGUAL;
  }
});
Object.defineProperty(exports, "UNINSTALL_ALL_TASK_ID", {
  enumerable: true,
  get: function () {
    return _uninstall_all.UNINSTALL_ALL_TASK_ID;
  }
});
Object.defineProperty(exports, "UNINSTALL_ALL_TASK_ID_MULTILINGUAL", {
  enumerable: true,
  get: function () {
    return _uninstall_all.UNINSTALL_ALL_TASK_ID_MULTILINGUAL;
  }
});
Object.defineProperty(exports, "getTaskStatus", {
  enumerable: true,
  get: function () {
    return _utils.getTaskStatus;
  }
});
exports.registerTaskDefinitions = void 0;
Object.defineProperty(exports, "scheduleEnsureSecurityLabsUpToDateTask", {
  enumerable: true,
  get: function () {
    return _ensure_security_labs_up_to_date.scheduleEnsureSecurityLabsUpToDateTask;
  }
});
Object.defineProperty(exports, "scheduleEnsureUpToDateTask", {
  enumerable: true,
  get: function () {
    return _ensure_up_to_date.scheduleEnsureUpToDateTask;
  }
});
Object.defineProperty(exports, "scheduleInstallAllTask", {
  enumerable: true,
  get: function () {
    return _install_all.scheduleInstallAllTask;
  }
});
Object.defineProperty(exports, "scheduleUninstallAllTask", {
  enumerable: true,
  get: function () {
    return _uninstall_all.scheduleUninstallAllTask;
  }
});
Object.defineProperty(exports, "waitUntilTaskCompleted", {
  enumerable: true,
  get: function () {
    return _utils.waitUntilTaskCompleted;
  }
});
var _ensure_up_to_date = require("./ensure_up_to_date");
var _ensure_security_labs_up_to_date = require("./ensure_security_labs_up_to_date");
var _install_all = require("./install_all");
var _uninstall_all = require("./uninstall_all");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerTaskDefinitions = ({
  getServices,
  taskManager
}) => {
  (0, _ensure_up_to_date.registerEnsureUpToDateTaskDefinition)({
    getServices,
    taskManager
  });
  (0, _ensure_security_labs_up_to_date.registerEnsureSecurityLabsUpToDateTaskDefinition)({
    getServices,
    taskManager
  });
  (0, _install_all.registerInstallAllTaskDefinition)({
    getServices,
    taskManager
  });
  (0, _uninstall_all.registerUninstallAllTaskDefinition)({
    getServices,
    taskManager
  });
};
exports.registerTaskDefinitions = registerTaskDefinitions;