"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scheduleEnsureSecurityLabsUpToDateTask = exports.registerEnsureSecurityLabsUpToDateTaskDefinition = exports.ENSURE_SECURITY_LABS_UP_TO_DATE_TASK_TYPE = exports.ENSURE_SECURITY_LABS_UP_TO_DATE_TASK_ID_MULTILINGUAL = exports.ENSURE_SECURITY_LABS_UP_TO_DATE_TASK_ID = void 0;
var _inferenceCommon = require("@kbn/inference-common");
var _is_default_inference_endpoint = require("@kbn/product-doc-common/src/is_default_inference_endpoint");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENSURE_SECURITY_LABS_UP_TO_DATE_TASK_TYPE = exports.ENSURE_SECURITY_LABS_UP_TO_DATE_TASK_TYPE = 'ProductDocBase:EnsureSecurityLabsUpToDate';
const ENSURE_SECURITY_LABS_UP_TO_DATE_TASK_ID = exports.ENSURE_SECURITY_LABS_UP_TO_DATE_TASK_ID = 'ProductDocBase:EnsureSecurityLabsUpToDate';
const ENSURE_SECURITY_LABS_UP_TO_DATE_TASK_ID_MULTILINGUAL = exports.ENSURE_SECURITY_LABS_UP_TO_DATE_TASK_ID_MULTILINGUAL = 'ProductDocBase:EnsureSecurityLabsUpToDateMultilingual';
const registerEnsureSecurityLabsUpToDateTaskDefinition = ({
  getServices,
  taskManager
}) => {
  taskManager.registerTaskDefinitions({
    [ENSURE_SECURITY_LABS_UP_TO_DATE_TASK_TYPE]: {
      title: 'Ensure Security Labs up to date task',
      timeout: '10m',
      maxAttempts: 3,
      createTaskRunner: context => {
        return {
          async run() {
            var _context$taskInstance, _context$taskInstance2, _context$taskInstance3, _context$taskInstance4, _context$taskInstance5;
            const inferenceId = (_context$taskInstance = (_context$taskInstance2 = context.taskInstance) === null || _context$taskInstance2 === void 0 ? void 0 : (_context$taskInstance3 = _context$taskInstance2.params) === null || _context$taskInstance3 === void 0 ? void 0 : _context$taskInstance3.inferenceId) !== null && _context$taskInstance !== void 0 ? _context$taskInstance : _inferenceCommon.defaultInferenceEndpoints.ELSER;
            const forceUpdate = (_context$taskInstance4 = context.taskInstance) === null || _context$taskInstance4 === void 0 ? void 0 : (_context$taskInstance5 = _context$taskInstance4.params) === null || _context$taskInstance5 === void 0 ? void 0 : _context$taskInstance5.forceUpdate;
            const {
              packageInstaller
            } = getServices();
            return packageInstaller.ensureSecurityLabsUpToDate({
              inferenceId,
              forceUpdate
            });
          }
        };
      },
      stateSchemaByVersion: {}
    }
  });
};
exports.registerEnsureSecurityLabsUpToDateTaskDefinition = registerEnsureSecurityLabsUpToDateTaskDefinition;
const scheduleEnsureSecurityLabsUpToDateTask = async ({
  taskManager,
  logger,
  inferenceId,
  forceUpdate
}) => {
  const taskId = (0, _is_default_inference_endpoint.isImpliedDefaultElserInferenceId)(inferenceId) ? ENSURE_SECURITY_LABS_UP_TO_DATE_TASK_ID : ENSURE_SECURITY_LABS_UP_TO_DATE_TASK_ID_MULTILINGUAL;
  try {
    await taskManager.ensureScheduled({
      id: taskId,
      taskType: ENSURE_SECURITY_LABS_UP_TO_DATE_TASK_TYPE,
      params: {
        inferenceId,
        forceUpdate
      },
      state: {},
      scope: ['productDoc']
    });
    await taskManager.runSoon(taskId);
    logger.info(`Task ${taskId} scheduled to run soon`);
  } catch (e) {
    if (!(0, _utils.isTaskCurrentlyRunningError)(e)) {
      throw e;
    }
  }
  return taskId;
};
exports.scheduleEnsureSecurityLabsUpToDateTask = scheduleEnsureSecurityLabsUpToDateTask;