"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndicesForResourceTypes = exports.getIndicesForProductNames = void 0;
var _productDocCommon = require("@kbn/product-doc-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIndicesForProductNames = (productNames, inferenceId) => {
  if (!productNames || !productNames.length) {
    return Object.values(_productDocCommon.DocumentationProduct).map(productName => (0, _productDocCommon.getProductDocIndexName)(productName, inferenceId));
  }
  return productNames.map(productName => (0, _productDocCommon.getProductDocIndexName)(productName, inferenceId));
};

/**
 * Returns the indices to search for the requested resource types.
 */
exports.getIndicesForProductNames = getIndicesForProductNames;
const getIndicesForResourceTypes = (productNames, inferenceId, resourceTypes = [_productDocCommon.ResourceTypes.productDoc]) => {
  const indices = [];
  if (resourceTypes.includes(_productDocCommon.ResourceTypes.productDoc)) {
    const productIndices = getIndicesForProductNames(productNames, inferenceId);
    indices.push(...(Array.isArray(productIndices) ? productIndices : [productIndices]));
  }
  if (resourceTypes.includes(_productDocCommon.ResourceTypes.securityLabs)) {
    indices.push((0, _productDocCommon.getSecurityLabsIndexName)(inferenceId));
  }
  return indices.length === 1 ? indices[0] : indices;
};
exports.getIndicesForResourceTypes = getIndicesForResourceTypes;