"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _productDocCommon = require("@kbn/product-doc-common");
var _utils = require("./utils");
var _perform_search = require("./perform_search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SECURITY_LABS_BASE_URL = 'https://www.elastic.co/security-labs/';
const isSecurityLabsHit = hit => {
  return Boolean(hit._source && typeof hit._source === 'object' && 'title' in hit._source);
};
const mapSecurityLabsResult = docHit => {
  var _content$text, _content, _docHit$highlight;
  const source = docHit._source;
  const content = source.content;
  return {
    title: source.title,
    content: typeof content === 'string' ? content : (_content$text = content === null || content === void 0 ? void 0 : content.text) !== null && _content$text !== void 0 ? _content$text : '',
    url: `${SECURITY_LABS_BASE_URL}${source.slug}`,
    productName: 'security',
    highlights: (_content = (_docHit$highlight = docHit.highlight) === null || _docHit$highlight === void 0 ? void 0 : _docHit$highlight.content) !== null && _content !== void 0 ? _content : []
  };
};
class SearchService {
  constructor({
    logger,
    esClient
  }) {
    (0, _defineProperty2.default)(this, "log", void 0);
    (0, _defineProperty2.default)(this, "esClient", void 0);
    this.log = logger;
    this.esClient = esClient;
  }
  async search(options) {
    var _options$resourceType;
    const {
      query,
      max = 3,
      highlights = 3,
      products,
      inferenceId
    } = options;
    const resourceTypes = (_options$resourceType = options.resourceTypes) !== null && _options$resourceType !== void 0 ? _options$resourceType : [_productDocCommon.ResourceTypes.productDoc];
    const results = [];
    if (resourceTypes.includes(_productDocCommon.ResourceTypes.productDoc)) {
      const productDocIndex = (0, _utils.getIndicesForResourceTypes)(products, inferenceId, [_productDocCommon.ResourceTypes.productDoc]);
      this.log.debug(`performing search - query=[${query}] at index=[${productDocIndex}] resourceType=[${_productDocCommon.ResourceTypes.productDoc}]`);
      results.push(...(await (0, _perform_search.performSearch)({
        searchQuery: query,
        size: max,
        highlights,
        index: productDocIndex,
        client: this.esClient
      })));
    }
    if (resourceTypes.includes(_productDocCommon.ResourceTypes.securityLabs)) {
      const securityLabsIndex = (0, _productDocCommon.getSecurityLabsIndexName)(inferenceId);
      this.log.debug(`performing search - query=[${query}] at index=[${securityLabsIndex}] resourceType=[${_productDocCommon.ResourceTypes.securityLabs}]`);
      results.push(...(await (0, _perform_search.performSecurityLabsSearch)({
        searchQuery: query,
        size: max,
        highlights,
        index: securityLabsIndex,
        client: this.esClient
      })));
    }
    const sorted = results.slice().sort((a, b) => {
      var _b$_score, _a$_score;
      return ((_b$_score = b._score) !== null && _b$_score !== void 0 ? _b$_score : 0) - ((_a$_score = a._score) !== null && _a$_score !== void 0 ? _a$_score : 0);
    }).slice(0, max);
    return {
      results: sorted.map(hit => {
        if (isSecurityLabsHit(hit)) {
          return mapSecurityLabsResult(hit);
        }
        return (0, _utils.mapResult)(hit);
      })
    };
  }
}
exports.SearchService = SearchService;