"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSecurityLabsVersions = exports.fetchArtifactVersions = void 0;
var _productDocCommon = require("@kbn/product-doc-common");
var fs = _interopRequireWildcard(require("fs"));
var _nodeFetch = _interopRequireDefault(require("node-fetch"));
var _path = _interopRequireDefault(require("path"));
var _url = require("url");
var _xml2js = require("xml2js");
var _local_artifacts = require("../utils/local_artifacts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchArtifactVersions = async ({
  artifactRepositoryUrl
}) => {
  const parsedUrl = new _url.URL(artifactRepositoryUrl);
  let xml;
  if (parsedUrl.protocol === 'file:') {
    const file = await fetchLocalFile(parsedUrl);
    xml = file.toString();
  } else {
    const res = await (0, _nodeFetch.default)(`${artifactRepositoryUrl}?max-keys=1000`);
    xml = await res.text();
  }
  return new Promise((resolve, reject) => {
    (0, _xml2js.parseString)(xml, (err, result) => {
      var _result$ListBucketRes, _result$ListBucketRes2;
      if (err) {
        reject(err);
      }

      // 6 artifacts per minor stack version means we have a few decades before facing this problem
      if ((_result$ListBucketRes = result.ListBucketResult.IsTruncated) !== null && _result$ListBucketRes !== void 0 && _result$ListBucketRes.includes('true')) {
        throw new Error('bucket content is truncated, cannot retrieve all versions');
      }
      const allowedProductNames = Object.values(_productDocCommon.DocumentationProduct);
      const record = {};
      allowedProductNames.forEach(product => {
        record[product] = [];
      });
      (_result$ListBucketRes2 = result.ListBucketResult.Contents) === null || _result$ListBucketRes2 === void 0 ? void 0 : _result$ListBucketRes2.forEach(contentEntry => {
        const artifactName = contentEntry.Key[0];
        const parsed = (0, _productDocCommon.parseArtifactName)(artifactName);
        if (parsed) {
          const {
            productName,
            productVersion
          } = parsed;
          record[productName].push(productVersion);
        }
      });
      resolve(record);
    });
  });
};
exports.fetchArtifactVersions = fetchArtifactVersions;
function fetchLocalFile(parsedUrl) {
  return new Promise((resolve, reject) => {
    const normalizedPath = (0, _local_artifacts.resolveLocalArtifactsPath)(parsedUrl);
    const xmlFilePath = _path.default.join(normalizedPath, 'index.xml');
    fs.readFile(xmlFilePath, (err, data) => {
      if (err) {
        reject(err);
      } else {
        resolve(data);
      }
    });
  });
}
/**
 * Fetches available Security Labs artifact versions from the repository.
 */
const fetchSecurityLabsVersions = async ({
  artifactRepositoryUrl
}) => {
  const parsedUrl = new _url.URL(artifactRepositoryUrl);
  let xml;
  if (parsedUrl.protocol === 'file:') {
    const file = await fetchLocalFile(parsedUrl);
    xml = file.toString();
  } else {
    const res = await (0, _nodeFetch.default)(`${artifactRepositoryUrl}?max-keys=1000`);
    xml = await res.text();
  }
  return new Promise((resolve, reject) => {
    (0, _xml2js.parseString)(xml, (err, result) => {
      var _result$ListBucketRes3, _result$ListBucketRes4;
      if (err) {
        reject(err);
        return;
      }
      if ((_result$ListBucketRes3 = result.ListBucketResult.IsTruncated) !== null && _result$ListBucketRes3 !== void 0 && _result$ListBucketRes3.includes('true')) {
        throw new Error('bucket content is truncated, cannot retrieve all versions');
      }
      const versions = [];
      (_result$ListBucketRes4 = result.ListBucketResult.Contents) === null || _result$ListBucketRes4 === void 0 ? void 0 : _result$ListBucketRes4.forEach(contentEntry => {
        const artifactName = contentEntry.Key[0];
        const parsed = (0, _productDocCommon.parseSecurityLabsArtifactName)(artifactName);
        if (parsed) {
          versions.push(parsed.version);
        }
      });
      resolve(versions);
    });
  });
};
exports.fetchSecurityLabsVersions = fetchSecurityLabsVersions;