"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProductDocInstallClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _productDocCommon = require("@kbn/product-doc-common");
var _inferenceCommon = require("@kbn/inference-common");
var _is_default_inference_endpoint = require("@kbn/product-doc-common/src/is_default_inference_endpoint");
var _consts = require("../../../common/consts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ProductDocInstallClient {
  constructor({
    soClient,
    log
  }) {
    (0, _defineProperty2.default)(this, "soClient", void 0);
    (0, _defineProperty2.default)(this, "log", void 0);
    this.soClient = soClient;
    this.log = log;
  }
  async getPreviouslyInstalledInferenceIds() {
    const query = {
      type: _consts.productDocInstallStatusSavedObjectTypeName,
      perPage: 100
    };
    const response = await this.soClient.find(query);
    const savedObjects = response === null || response === void 0 ? void 0 : response.saved_objects.filter(so => {
      var _so$attributes$resour, _so$attributes, _so$attributes2;
      // Treat missing resource_type as product_doc for backwards compatibility.
      const resourceType = (_so$attributes$resour = (_so$attributes = so.attributes) === null || _so$attributes === void 0 ? void 0 : _so$attributes.resource_type) !== null && _so$attributes$resour !== void 0 ? _so$attributes$resour : _productDocCommon.ResourceTypes.productDoc;
      return resourceType === _productDocCommon.ResourceTypes.productDoc && ((_so$attributes2 = so.attributes) === null || _so$attributes2 === void 0 ? void 0 : _so$attributes2.installation_status) === 'installed';
    });
    const inferenceIds = new Set(savedObjects.map(so => {
      var _so$attributes$infere, _so$attributes3;
      return (_so$attributes$infere = (_so$attributes3 = so.attributes) === null || _so$attributes3 === void 0 ? void 0 : _so$attributes3.inference_id) !== null && _so$attributes$infere !== void 0 ? _so$attributes$infere : _inferenceCommon.defaultInferenceEndpoints.ELSER;
    }));
    return Array.from(inferenceIds);
  }
  async getPreviouslyInstalledSecurityLabsInferenceIds() {
    const query = {
      type: _consts.productDocInstallStatusSavedObjectTypeName,
      perPage: 100
    };
    const response = await this.soClient.find(query);
    const savedObjects = response === null || response === void 0 ? void 0 : response.saved_objects.filter(so => {
      var _so$attributes4, _so$attributes5;
      return ((_so$attributes4 = so.attributes) === null || _so$attributes4 === void 0 ? void 0 : _so$attributes4.resource_type) === _productDocCommon.ResourceTypes.securityLabs && ((_so$attributes5 = so.attributes) === null || _so$attributes5 === void 0 ? void 0 : _so$attributes5.installation_status) === 'installed';
    });
    const inferenceIds = new Set(savedObjects.map(so => {
      var _so$attributes$infere2, _so$attributes6;
      return (_so$attributes$infere2 = (_so$attributes6 = so.attributes) === null || _so$attributes6 === void 0 ? void 0 : _so$attributes6.inference_id) !== null && _so$attributes$infere2 !== void 0 ? _so$attributes$infere2 : _inferenceCommon.defaultInferenceEndpoints.ELSER;
    }));
    return Array.from(inferenceIds);
  }
  async getInstallationStatus({
    inferenceId
  }) {
    const query = {
      type: _consts.productDocInstallStatusSavedObjectTypeName,
      perPage: 100
    };
    const installStatus = Object.values(_productDocCommon.DocumentationProduct).reduce((memo, product) => {
      memo[product] = {
        status: 'uninstalled'
      };
      return memo;
    }, {});
    try {
      const response = await this.soClient.find(query);
      const savedObjects = (0, _is_default_inference_endpoint.isImpliedDefaultElserInferenceId)(inferenceId) ? response === null || response === void 0 ? void 0 : response.saved_objects.filter(so => (0, _is_default_inference_endpoint.isImpliedDefaultElserInferenceId)(so.attributes.inference_id)) : response === null || response === void 0 ? void 0 : response.saved_objects.filter(so => so.attributes.inference_id === inferenceId);

      // Filter out Security Labs records (stored in the same SO type) so they don't overwrite
      // the product docs "security" product status.
      const productDocsSavedObjects = savedObjects === null || savedObjects === void 0 ? void 0 : savedObjects.filter(so => {
        var _so$attributes$resour2, _so$attributes7;
        // Treat missing resource_type as product_doc for backwards compatibility.
        const resourceType = (_so$attributes$resour2 = (_so$attributes7 = so.attributes) === null || _so$attributes7 === void 0 ? void 0 : _so$attributes7.resource_type) !== null && _so$attributes$resour2 !== void 0 ? _so$attributes$resour2 : _productDocCommon.ResourceTypes.productDoc;
        return resourceType === _productDocCommon.ResourceTypes.productDoc;
      });
      productDocsSavedObjects === null || productDocsSavedObjects === void 0 ? void 0 : productDocsSavedObjects.forEach(({
        attributes
      }) => {
        installStatus[attributes.product_name] = {
          status: attributes.installation_status,
          version: attributes.product_version,
          ...(attributes.last_installation_failure_reason ? {
            failureReason: attributes.last_installation_failure_reason
          } : {})
        };
      });
      return installStatus;
    } catch (error) {
      this.log.error(`An error occurred getting installation status saved object for inferenceId [${inferenceId}]
        Query: ${JSON.stringify(query, null, 2)}`, error);
      return installStatus;
    }
  }
  async setInstallationStarted(fields) {
    const {
      productName,
      productVersion,
      inferenceId
    } = fields;
    const objectId = getObjectIdFromProductName(productName, inferenceId);
    const attributes = {
      product_name: productName,
      product_version: productVersion,
      installation_status: 'installing',
      last_installation_failure_reason: '',
      inference_id: inferenceId,
      resource_type: _productDocCommon.ResourceTypes.productDoc
    };
    await this.soClient.update(_consts.productDocInstallStatusSavedObjectTypeName, objectId, attributes, {
      upsert: attributes
    });
  }
  async setUninstallationStarted(productName, inferenceId) {
    const objectId = getObjectIdFromProductName(productName, inferenceId);
    await this.soClient.update(_consts.productDocInstallStatusSavedObjectTypeName, objectId, {
      installation_status: 'uninstalling',
      inference_id: inferenceId,
      resource_type: _productDocCommon.ResourceTypes.productDoc
    });
  }
  async setInstallationSuccessful(productName, indexName, inferenceId) {
    const objectId = getObjectIdFromProductName(productName, inferenceId);
    await this.soClient.update(_consts.productDocInstallStatusSavedObjectTypeName, objectId, {
      installation_status: 'installed',
      index_name: indexName,
      inference_id: inferenceId,
      resource_type: _productDocCommon.ResourceTypes.productDoc
    });
  }
  async setInstallationFailed(productName, failureReason, inferenceId) {
    const objectId = getObjectIdFromProductName(productName, inferenceId);
    await this.soClient.update(_consts.productDocInstallStatusSavedObjectTypeName, objectId, {
      installation_status: 'error',
      last_installation_failure_reason: failureReason,
      inference_id: inferenceId,
      resource_type: _productDocCommon.ResourceTypes.productDoc
    });
  }
  async setUninstalled(productName, inferenceId) {
    const objectId = getObjectIdFromProductName(productName, inferenceId);
    try {
      await this.soClient.update(_consts.productDocInstallStatusSavedObjectTypeName, objectId, {
        installation_status: 'uninstalled',
        last_installation_failure_reason: '',
        inference_id: inferenceId,
        resource_type: _productDocCommon.ResourceTypes.productDoc
      });
    } catch (e) {
      if (!_coreSavedObjectsServer.SavedObjectsErrorHelpers.isNotFoundError(e)) {
        throw e;
      }
    }
  }

  // Security Labs status helpers (stored in the same SO type but a different object id to avoid collisions)

  async getSecurityLabsInstallationStatus({
    inferenceId
  }) {
    const objectId = getSecurityLabsObjectId(inferenceId);
    try {
      const so = await this.soClient.get(_consts.productDocInstallStatusSavedObjectTypeName, objectId);
      return {
        status: so.attributes.installation_status,
        version: so.attributes.product_version,
        ...(so.attributes.last_installation_failure_reason ? {
          failureReason: so.attributes.last_installation_failure_reason
        } : {})
      };
    } catch (e) {
      if (_coreSavedObjectsServer.SavedObjectsErrorHelpers.isNotFoundError(e)) {
        return {
          status: 'uninstalled'
        };
      }
      throw e;
    }
  }
  async setSecurityLabsInstallationStarted(fields) {
    const {
      version,
      inferenceId
    } = fields;
    const objectId = getSecurityLabsObjectId(inferenceId);
    const attributes = {
      // Use product_name=security but disambiguate with resource_type, and a different object id.
      product_name: 'security',
      product_version: version,
      installation_status: 'installing',
      last_installation_failure_reason: '',
      inference_id: inferenceId,
      resource_type: _productDocCommon.ResourceTypes.securityLabs
    };
    await this.soClient.update(_consts.productDocInstallStatusSavedObjectTypeName, objectId, attributes, {
      upsert: attributes
    });
  }
  async setSecurityLabsInstallationSuccessful(fields) {
    const {
      version,
      indexName,
      inferenceId
    } = fields;
    const objectId = getSecurityLabsObjectId(inferenceId);
    await this.soClient.update(_consts.productDocInstallStatusSavedObjectTypeName, objectId, {
      product_name: 'security',
      product_version: version,
      installation_status: 'installed',
      index_name: indexName,
      inference_id: inferenceId,
      resource_type: _productDocCommon.ResourceTypes.securityLabs
    });
  }
  async setSecurityLabsInstallationFailed(fields) {
    const {
      version,
      failureReason,
      inferenceId
    } = fields;
    const objectId = getSecurityLabsObjectId(inferenceId);
    await this.soClient.update(_consts.productDocInstallStatusSavedObjectTypeName, objectId, {
      ...(version ? {
        product_version: version
      } : {}),
      installation_status: 'error',
      last_installation_failure_reason: failureReason,
      inference_id: inferenceId,
      resource_type: _productDocCommon.ResourceTypes.securityLabs
    });
  }
  async setSecurityLabsUninstalled(inferenceId) {
    const objectId = getSecurityLabsObjectId(inferenceId);
    try {
      await this.soClient.update(_consts.productDocInstallStatusSavedObjectTypeName, objectId, {
        installation_status: 'uninstalled',
        last_installation_failure_reason: '',
        inference_id: inferenceId,
        resource_type: _productDocCommon.ResourceTypes.securityLabs
      });
    } catch (e) {
      if (!_coreSavedObjectsServer.SavedObjectsErrorHelpers.isNotFoundError(e)) {
        throw e;
      }
    }
  }
}
exports.ProductDocInstallClient = ProductDocInstallClient;
const getObjectIdFromProductName = (productName, inferenceId) => {
  const inferenceIdPart = !(0, _is_default_inference_endpoint.isImpliedDefaultElserInferenceId)(inferenceId) ? `-${inferenceId}` : '';
  return `kb-product-doc-${productName}${inferenceIdPart}-status`.toLowerCase();
};
const getSecurityLabsObjectId = inferenceId => {
  const inferenceIdPart = !(0, _is_default_inference_endpoint.isImpliedDefaultElserInferenceId)(inferenceId) ? `-${inferenceId}` : '';
  return `kb-security-labs${inferenceIdPart}-status`.toLowerCase();
};