"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.productDocInstallStatusSavedObjectType = void 0;
var _configSchema = require("@kbn/config-schema");
var _consts = require("../../common/consts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const productDocInstallStatusAttributesSchemaV1 = _configSchema.schema.object({
  product_name: _configSchema.schema.string(),
  product_version: _configSchema.schema.string(),
  installation_status: _configSchema.schema.string(),
  last_installation_date: _configSchema.schema.maybe(_configSchema.schema.number()),
  last_installation_failure_reason: _configSchema.schema.maybe(_configSchema.schema.string()),
  index_name: _configSchema.schema.maybe(_configSchema.schema.string()),
  inference_id: _configSchema.schema.maybe(_configSchema.schema.string())
});
const productDocInstallStatusAttributesSchemaV2 = productDocInstallStatusAttributesSchemaV1.extends({
  resource_type: _configSchema.schema.maybe(_configSchema.schema.string())
});

/**
 * Interface describing the raw attributes of the product doc install SO type.
 * Contains more fields than the mappings, which only list
 * indexed fields.
 */

const modelVersion1 = {
  changes: [{
    type: 'mappings_addition',
    addedMappings: {
      inference_id: {
        type: 'keyword'
      }
    }
  }]
};
const modelVersion2 = {
  changes: [{
    type: 'mappings_addition',
    addedMappings: {
      resource_type: {
        type: 'keyword'
      }
    }
  }],
  schemas: {
    forwardCompatibility: productDocInstallStatusAttributesSchemaV2.extends({}, {
      unknowns: 'ignore'
    }),
    create: productDocInstallStatusAttributesSchemaV2
  }
};
const productDocInstallStatusSavedObjectType = exports.productDocInstallStatusSavedObjectType = {
  name: _consts.productDocInstallStatusSavedObjectTypeName,
  hidden: true,
  namespaceType: 'agnostic',
  mappings: {
    dynamic: false,
    properties: {
      product_name: {
        type: 'keyword'
      },
      product_version: {
        type: 'keyword'
      },
      installation_status: {
        type: 'keyword'
      },
      last_installation_date: {
        type: 'date'
      },
      index_name: {
        type: 'keyword'
      },
      inference_id: {
        type: 'keyword'
      },
      resource_type: {
        type: 'keyword'
      }
    }
  },
  management: {
    importableAndExportable: false
  },
  modelVersions: {
    '1': modelVersion1,
    '2': modelVersion2
  }
};