"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLegacyKbnPalettes = void 0;
var _palettes = require("../../classes/palettes");
var _categorical = require("./categorical");
var _gradient = require("./gradient");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const darkLegacyKbnPalettes = new _palettes.KbnPalettes([_categorical.kibana7Palette, _categorical.kibana4Palette, _categorical.kibana7BehindText, (0, _categorical.getNeutralPalette)(true), _gradient.complementaryPalette, _gradient.coolPalette, _gradient.grayPalette, _gradient.greenPalette, _gradient.redPalette, _gradient.statusPalette, _gradient.temperaturePalette, _gradient.warmPalette, _categorical.elasticClassicPalette], _categorical.kibana7Palette);
const lightLegacyKbnPalettes = new _palettes.KbnPalettes([_categorical.kibana7Palette, _categorical.kibana4Palette, _categorical.kibana7BehindText, (0, _categorical.getNeutralPalette)(true), _gradient.complementaryPalette, _gradient.coolPalette, _gradient.grayPalette, _gradient.greenPalette, _gradient.redPalette, _gradient.statusPalette, _gradient.temperaturePalette, _gradient.warmPalette, _categorical.elasticClassicPalette], _categorical.kibana7Palette);
const getLegacyKbnPalettes = darkMode => darkMode ? darkLegacyKbnPalettes : lightLegacyKbnPalettes;
exports.getLegacyKbnPalettes = getLegacyKbnPalettes;