"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.upgradeIntegration = void 0;
var _semver = require("semver");
var _packages = require("@kbn/fleet-plugin/server/services/epm/packages");
var _registry = require("@kbn/fleet-plugin/server/services/epm/registry");
var _constants = require("@kbn/spaces-plugin/common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Conditionally upgrade osquery integration in order to fix 8.6.0 agent issue
const upgradeIntegration = async ({
  packageInfo,
  client,
  esClient,
  logger
}) => {
  var _packageInfo$version;
  if (packageInfo && (0, _semver.satisfies)((_packageInfo$version = packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.version) !== null && _packageInfo$version !== void 0 ? _packageInfo$version : '', '<1.6.0')) {
    try {
      logger.info('Updating osquery_manager integration');
      await (0, _packages.installPackage)({
        installSource: 'registry',
        savedObjectsClient: client,
        pkgkey: (0, _registry.pkgToPkgKey)({
          name: packageInfo.name,
          version: '1.6.0' // This package upgrade is specific to a bug fix, so keeping the upgrade focused on 1.6.0
        }),
        esClient,
        spaceId: packageInfo.installed_kibana_space_id || _constants.DEFAULT_SPACE_ID,
        // Force install the package will update the index template and the datastream write indices
        force: true
      });
      logger.info('osquery_manager integration updated');
    } catch (e) {
      logger.error(e);
    }
  }
};
exports.upgradeIntegration = upgradeIntegration;