"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInternalSavedObjectsClientForSpaceId = createInternalSavedObjectsClientForSpaceId;
exports.getInternalSavedObjectsClient = getInternalSavedObjectsClient;
exports.getInternalSavedObjectsClientForSpaceId = getInternalSavedObjectsClientForSpaceId;
var _coreSavedObjectsApiServerInternal = require("@kbn/core-saved-objects-api-server-internal");
var _coreHttpServerUtils = require("@kbn/core-http-server-utils");
var _common = require("@kbn/spaces-plugin/common");
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getInternalSavedObjectsClient(coreStart) {
  return new _coreSavedObjectsApiServerInternal.SavedObjectsClient(coreStart.savedObjects.createInternalRepository());
}
function getInternalSavedObjectsClientForSpaceId(coreStart, spaceId) {
  const request = (0, _coreHttpServerUtils.kibanaRequestFactory)({
    headers: {},
    path: '/',
    route: {
      settings: {}
    },
    url: {
      href: '',
      hash: ''
    },
    raw: {
      req: {
        url: '/'
      }
    }
  });
  if (spaceId && spaceId !== _common.DEFAULT_SPACE_ID) {
    coreStart.http.basePath.set(request, `/s/${spaceId}`);
  }

  // soClient as kibana internal users, be careful on how you use it, security is not enabled
  return coreStart.savedObjects.getScopedClient(request, {
    excludedExtensions: [_coreSavedObjectsServer.SECURITY_EXTENSION_ID]
  });
}
async function createInternalSavedObjectsClientForSpaceId(osqueryContext, request) {
  var _space$id;
  const space = await osqueryContext.service.getActiveSpace(request);
  const [core] = await osqueryContext.getStartServices();
  return getInternalSavedObjectsClientForSpaceId(core, (_space$id = space === null || space === void 0 ? void 0 : space.id) !== null && _space$id !== void 0 ? _space$id : _common.DEFAULT_SPACE_ID);
}