"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildActionsQuery = void 0;
var _common = require("@kbn/fleet-plugin/common");
var _build_query = require("../../../../../utils/build_query");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildActionsQuery = ({
  kuery = '',
  sort,
  pagination: {
    cursorStart,
    querySize
  },
  componentTemplateExists,
  spaceId
}) => {
  const {
    bool: {
      filter
    }
  } = (0, _build_query.getQueryFilter)({
    filter: kuery
  });
  let extendedFilter = filter;
  if (spaceId === 'default') {
    // For default space, include docs where space_id matches 'default' OR where space_id field does not exist
    extendedFilter = [{
      bool: {
        should: [{
          term: {
            space_id: 'default'
          }
        }, {
          bool: {
            must_not: {
              exists: {
                field: 'space_id'
              }
            }
          }
        }]
      }
    }, ...filter];
  } else {
    // For other spaces, only include docs where space_id matches the current spaceId
    extendedFilter = [...filter, {
      term: {
        space_id: spaceId
      }
    }];
  }
  return {
    allow_no_indices: true,
    index: componentTemplateExists ? `${_constants.ACTIONS_INDEX}*` : _common.AGENT_ACTIONS_INDEX,
    ignore_unavailable: true,
    query: {
      bool: {
        filter: extendedFilter,
        must: [{
          term: {
            type: {
              value: 'INPUT_ACTION'
            }
          }
        }, {
          term: {
            input_type: {
              value: 'osquery'
            }
          }
        }]
      }
    },
    from: cursorStart,
    size: querySize,
    track_total_hits: true,
    fields: ['*'],
    sort: [{
      [sort.field]: {
        order: sort.direction
      }
    }]
  };
};
exports.buildActionsQuery = buildActionsQuery;