"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createToolResultStoreMock = exports.createToolProviderMock = exports.createScopedRunnerMock = exports.createScopedRunnerDepsMock = exports.createRunnerDepsMock = exports.createAttachmentsServiceStartMock = exports.createAttachmentsService = exports.createAgentHandlerContextMock = void 0;
var _loggingMocks = require("@kbn/logging-mocks");
var _mocks = require("@kbn/core/server/mocks");
var _mocks2 = require("@kbn/spaces-plugin/server/mocks");
var _mocks3 = require("@kbn/actions-plugin/server/mocks");
var _model_provider = require("./model_provider");
var _tools = require("./tools");
var _agents = require("./agents");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createToolProviderMock = () => {
  return {
    has: jest.fn(),
    get: jest.fn(),
    list: jest.fn()
  };
};
exports.createToolProviderMock = createToolProviderMock;
const createToolResultStoreMock = () => {
  return {
    has: jest.fn(),
    get: jest.fn(),
    add: jest.fn(),
    delete: jest.fn(),
    asReadonly: jest.fn()
  };
};
exports.createToolResultStoreMock = createToolResultStoreMock;
const createAttachmentsServiceStartMock = () => {
  return {
    validate: jest.fn(),
    getTypeDefinition: jest.fn()
  };
};
exports.createAttachmentsServiceStartMock = createAttachmentsServiceStartMock;
const createAttachmentsService = () => {
  return {
    getTypeDefinition: jest.fn(),
    convertAttachmentTool: jest.fn()
  };
};
exports.createAttachmentsService = createAttachmentsService;
const createAgentHandlerContextMock = () => {
  return {
    request: _mocks.httpServerMock.createKibanaRequest(),
    spaceId: 'default',
    esClient: _mocks.elasticsearchServiceMock.createScopedClusterClient(),
    modelProvider: (0, _model_provider.createModelProviderMock)(),
    toolProvider: createToolProviderMock(),
    runner: createScopedRunnerMock(),
    attachments: createAttachmentsService(),
    resultStore: createToolResultStoreMock(),
    events: {
      emit: jest.fn()
    },
    logger: _loggingMocks.loggerMock.create()
  };
};
exports.createAgentHandlerContextMock = createAgentHandlerContextMock;
const createScopedRunnerMock = () => {
  return {
    runTool: jest.fn(),
    runInternalTool: jest.fn(),
    runAgent: jest.fn()
  };
};
exports.createScopedRunnerMock = createScopedRunnerMock;
const createScopedRunnerDepsMock = () => {
  return {
    elasticsearch: _mocks.elasticsearchServiceMock.createStart(),
    security: _mocks.securityServiceMock.createStart(),
    spaces: _mocks2.spacesMock.createStart(),
    actions: _mocks3.actionsMock.createStart(),
    modelProvider: (0, _model_provider.createModelProviderMock)(),
    toolsService: (0, _tools.createToolsServiceStartMock)(),
    agentsService: (0, _agents.createAgentsServiceStartMock)(),
    logger: _loggingMocks.loggerMock.create(),
    request: _mocks.httpServerMock.createKibanaRequest(),
    resultStore: createToolResultStoreMock(),
    attachmentsService: createAttachmentsServiceStartMock()
  };
};
exports.createScopedRunnerDepsMock = createScopedRunnerDepsMock;
const createRunnerDepsMock = () => {
  return {
    elasticsearch: _mocks.elasticsearchServiceMock.createStart(),
    security: _mocks.securityServiceMock.createStart(),
    spaces: _mocks2.spacesMock.createStart(),
    actions: _mocks3.actionsMock.createStart(),
    modelProviderFactory: (0, _model_provider.createModelProviderFactoryMock)(),
    toolsService: (0, _tools.createToolsServiceStartMock)(),
    agentsService: (0, _agents.createAgentsServiceStartMock)(),
    logger: _loggingMocks.loggerMock.create(),
    attachmentsService: createAttachmentsServiceStartMock()
  };
};
exports.createRunnerDepsMock = createRunnerDepsMock;