"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateWorkflowId = void 0;
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateWorkflowId = async ({
  workflows,
  workflowId,
  spaceId
}) => {
  const workflow = await workflows.management.getWorkflow(workflowId, spaceId);
  if (!workflow) {
    throw (0, _onechatCommon.createBadRequestError)(`Workflow '${workflowId}' not found`);
  }
};
exports.validateWorkflowId = validateWorkflowId;