"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toolHealthIndexName = exports.createStorage = void 0;
var _storageAdapter = require("@kbn/storage-adapter");
var _onechatServer = require("@kbn/onechat-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toolHealthIndexName = exports.toolHealthIndexName = (0, _onechatServer.chatSystemIndex)('tool-health');

// Re-export from common for convenience

const storageSettings = {
  name: toolHealthIndexName,
  schema: {
    properties: {
      tool_id: _storageAdapter.types.keyword({}),
      space: _storageAdapter.types.keyword({}),
      status: _storageAdapter.types.keyword({}),
      last_check: _storageAdapter.types.date({}),
      error_message: _storageAdapter.types.text({}),
      consecutive_failures: _storageAdapter.types.long({}),
      updated_at: _storageAdapter.types.date({})
    }
  }
};
const createStorage = ({
  logger,
  esClient
}) => {
  return new _storageAdapter.StorageIndexAdapter(esClient, logger, storageSettings);
};
exports.createStorage = createStorage;